package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VdocOs6;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VdocOs6DaoImpl generated by UDA, 30-jun-2017 14:27:59.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VdocOs6DaoImpl implements VdocOs6Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VdocOs6> rwMap = new RowMapper<VdocOs6>() {
		public VdocOs6 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VdocOs6(resultSet.getString("NUMEXP"),
					resultSet.getInt("NUMEJE"),
					resultSet.getInt("NUMVIS"), resultSet.getString("NOMTEC"),
					resultSet.getString("CODTEC"),
					resultSet.getDate("FECHAVIS"),
					resultSet.getDate("FECHAREVI"),
					resultSet.getString("NOMEMPRESA"),
					resultSet.getString("NIFEMPRESA"),
					resultSet.getString("PROVSSEMP"),
					resultSet.getString("NUMSSEMP"),
					resultSet.getString("DIGSSEMP"),
					resultSet.getString("DOMICILIOEMP"),
					resultSet.getString("CODPOSTALEMP"),
					resultSet.getString("CNAEEMP"),
					resultSet.getString("TIPAPERSI"),
					resultSet.getString("TIPAPERNO"),
					resultSet.getInt("NUMTRA"),
					resultSet.getString("DOMICILIOCEN"),
					resultSet.getString("CODPOSTALCEN"),
					resultSet.getString("TELCEN"),
					resultSet.getString("FAXCEN"),
					resultSet.getString("EMAILCEN"),
					resultSet.getString("CODMOD"),
					resultSet.getString("MOPEMP"),
					resultSet.getString("FOREMPSI"),
					resultSet.getString("FOREMPSIB"),
					resultSet.getString("FOREMPSII"),
					resultSet.getString("FOREMPSIS"),
					resultSet.getString("FOREMPNO"),
					resultSet.getString("MOPTRA"),
					resultSet.getBigDecimal("NUMTRAMOP"),
					resultSet.getString("FORTRASI"),
					resultSet.getBigDecimal("NUMTRASI"),
					resultSet.getString("FORTRASIB"),
					resultSet.getString("FORTRASII"),
					resultSet.getString("FORTRASIS"),
					resultSet.getString("FORTRANO"),
					resultSet.getBigDecimal("NUMTRANO"),
					resultSet.getString("MOPSPP"),
					resultSet.getString("SEGSPP"),
					resultSet.getString("HIGSPP"),
					resultSet.getString("ERGSPP"),
					resultSet.getString("MEDSPP"),
					resultSet.getString("MOPSPA"),
					resultSet.getString("SEGSPA"),
					resultSet.getString("HIGSPA"),
					resultSet.getString("ERGSPA"),
					resultSet.getString("MEDSPA"),
					resultSet.getString("NOMSPA"),
					resultSet.getString("COMSEG"),
					resultSet.getInt("NUMCOMSEG1"),
					resultSet.getInt("NUMCOMSEG2"),
					resultSet.getString("DELPRE"), resultSet.getInt("NUMDEL"),
					resultSet.getString("FORPRESI"),
					resultSet.getBigDecimal("NUMDEFSI"),
					resultSet.getString("FORPRENO"),
					resultSet.getBigDecimal("NUMDEFNO"),
					resultSet.getString("CODMER"),
					resultSet.getString("INDERSI"),
					resultSet.getString("INDERNO"),
					resultSet.getString("RIEEMP"),
					resultSet.getString("RIETRA"),
					resultSet.getString("RIESPP"),
					resultSet.getString("RIEOTRO"),
					resultSet.getString("RIESPA"),
					resultSet.getString("DESOTRO"),
					resultSet.getString("FIRMSI"),
					resultSet.getString("FIRMNO"),
					resultSet.getString("PARDELESI"),
					resultSet.getString("PARDELENO"),
					resultSet.getString("PARTRASI"),
					resultSet.getString("PARTRANO"),
					resultSet.getString("CONDELESI"),
					resultSet.getString("CONDELENO"),
					resultSet.getString("INFTRASI"),
					resultSet.getString("INFTRANO"),
					resultSet.getString("MEDPLASI"),
					resultSet.getString("MEDPLANO"),
					resultSet.getString("MEDRESSI"),
					resultSet.getString("MEDRESNO"),
					resultSet.getString("MEDFECSI"),
					resultSet.getString("MEDFECNO"),
					resultSet.getString("MEDPRESI"),
					resultSet.getString("MEDPRENO"),
					resultSet.getString("CODMED"),
					resultSet.getString("MEDPLAACTSI"),
					resultSet.getString("MEDPLAACTNO"),
					resultSet.getString("CONPLATRASI"),
					resultSet.getString("CONPLATRANO"),
					resultSet.getString("MEDSIMUSI"),
					resultSet.getString("MEDSIMUNO"),
					resultSet.getString("RMEEMP"),
					resultSet.getString("RMETRA"),
					resultSet.getString("RMESPP"),
					resultSet.getString("RMEOTRO"),
					resultSet.getString("RMESPA"),
					resultSet.getString("DESOTRO2"),
					resultSet.getString("FORTRAPRE"),
					resultSet.getString("VIGSAL"),
					resultSet.getString("TRASEN"),
					resultSet.getString("TRAMEN"),
					resultSet.getString("TRAMAT"),
					resultSet.getString("INFNUESI"),
					resultSet.getString("INFNUENO"),
					resultSet.getString("PLANACOGSI"),
					resultSet.getString("PLANACOGNO"),
					resultSet.getString("OBSERVACIONES"));
		}
	};

	private RowMapper<VdocOs6> rwMapPK = new RowMapper<VdocOs6>() {
		public VdocOs6 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VdocOs6(resultSet.getString("NUMEXP"),
					resultSet.getInt("NUMEJE"),
					resultSet.getInt("NUMVIS"), resultSet.getString("NOMTEC"),
					resultSet.getString("CODTEC"),
					resultSet.getDate("FECHAVIS"),
					resultSet.getDate("FECHAREVI"),
					resultSet.getString("NOMEMPRESA"),
					resultSet.getString("NIFEMPRESA"),
					resultSet.getString("PROVSSEMP"),
					resultSet.getString("NUMSSEMP"),
					resultSet.getString("DIGSSEMP"),
					resultSet.getString("DOMICILIOEMP"),
					resultSet.getString("CODPOSTALEMP"),
					resultSet.getString("CNAEEMP"),
					resultSet.getString("TIPAPERSI"),
					resultSet.getString("TIPAPERNO"),
					resultSet.getInt("NUMTRA"),
					resultSet.getString("DOMICILIOCEN"),
					resultSet.getString("CODPOSTALCEN"),
					resultSet.getString("TELCEN"),
					resultSet.getString("FAXCEN"),
					resultSet.getString("EMAILCEN"),
					resultSet.getString("CODMOD"),
					resultSet.getString("MOPEMP"),
					resultSet.getString("FOREMPSI"),
					resultSet.getString("FOREMPSIB"),
					resultSet.getString("FOREMPSII"),
					resultSet.getString("FOREMPSIS"),
					resultSet.getString("FOREMPNO"),
					resultSet.getString("MOPTRA"),
					resultSet.getBigDecimal("NUMTRAMOP"),
					resultSet.getString("FORTRASI"),
					resultSet.getBigDecimal("NUMTRASI"),
					resultSet.getString("FORTRASIB"),
					resultSet.getString("FORTRASII"),
					resultSet.getString("FORTRASIS"),
					resultSet.getString("FORTRANO"),
					resultSet.getBigDecimal("NUMTRANO"),
					resultSet.getString("MOPSPP"),
					resultSet.getString("SEGSPP"),
					resultSet.getString("HIGSPP"),
					resultSet.getString("ERGSPP"),
					resultSet.getString("MEDSPP"),
					resultSet.getString("MOPSPA"),
					resultSet.getString("SEGSPA"),
					resultSet.getString("HIGSPA"),
					resultSet.getString("ERGSPA"),
					resultSet.getString("MEDSPA"),
					resultSet.getString("NOMSPA"),
					resultSet.getString("COMSEG"),
					resultSet.getInt("NUMCOMSEG1"),
					resultSet.getInt("NUMCOMSEG2"),
					resultSet.getString("DELPRE"), resultSet.getInt("NUMDEL"),
					resultSet.getString("FORPRESI"),
					resultSet.getBigDecimal("NUMDEFSI"),
					resultSet.getString("FORPRENO"),
					resultSet.getBigDecimal("NUMDEFNO"),
					resultSet.getString("CODMER"),
					resultSet.getString("INDERSI"),
					resultSet.getString("INDERNO"),
					resultSet.getString("RIEEMP"),
					resultSet.getString("RIETRA"),
					resultSet.getString("RIESPP"),
					resultSet.getString("RIEOTRO"),
					resultSet.getString("RIESPA"),
					resultSet.getString("DESOTRO"),
					resultSet.getString("FIRMSI"),
					resultSet.getString("FIRMNO"),
					resultSet.getString("PARDELESI"),
					resultSet.getString("PARDELENO"),
					resultSet.getString("PARTRASI"),
					resultSet.getString("PARTRANO"),
					resultSet.getString("CONDELESI"),
					resultSet.getString("CONDELENO"),
					resultSet.getString("INFTRASI"),
					resultSet.getString("INFTRANO"),
					resultSet.getString("MEDPLASI"),
					resultSet.getString("MEDPLANO"),
					resultSet.getString("MEDRESSI"),
					resultSet.getString("MEDRESNO"),
					resultSet.getString("MEDFECSI"),
					resultSet.getString("MEDFECNO"),
					resultSet.getString("MEDPRESI"),
					resultSet.getString("MEDPRENO"),
					resultSet.getString("CODMED"),
					resultSet.getString("MEDPLAACTSI"),
					resultSet.getString("MEDPLAACTNO"),
					resultSet.getString("CONPLATRASI"),
					resultSet.getString("CONPLATRANO"),
					resultSet.getString("MEDSIMUSI"),
					resultSet.getString("MEDSIMUNO"),
					resultSet.getString("RMEEMP"),
					resultSet.getString("RMETRA"),
					resultSet.getString("RMESPP"),
					resultSet.getString("RMEOTRO"),
					resultSet.getString("RMESPA"),
					resultSet.getString("DESOTRO2"),
					resultSet.getString("FORTRAPRE"),
					resultSet.getString("VIGSAL"),
					resultSet.getString("TRASEN"),
					resultSet.getString("TRAMEN"),
					resultSet.getString("TRAMAT"),
					resultSet.getString("INFNUESI"),
					resultSet.getString("INFNUENO"),
					resultSet.getString("PLANACOGSI"),
					resultSet.getString("PLANACOGNO"),
					resultSet.getString("OBSERVACIONES"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VdocOs6 table.
	 * 
	 *  vdocos6
	 *            VdocOs6
	 *  VdocOs6
	 *
	 * @param vdocos6 the vdocos 6
	 * @return the vdoc os 6
	 */
	public VdocOs6 add(VdocOs6 vdocos6) {
		String query = "INSERT INTO VDOC_OS6 (NUMEXP, NUMEJE, NUMVIS, NOMTEC, CODTEC, FECHAVIS, FECHAREVI, NOMEMPRESA, NIFEMPRESA, PROVSSEMP, NUMSSEMP, DIGSSEMP, DOMICILIOEMP, CODPOSTALEMP, CNAEEMP, TIPAPERSI, TIPAPERNO, NUMTRA, DOMICILIOCEN, CODPOSTALCEN, TELCEN, FAXCEN, EMAILCEN, CODMOD, MOPEMP, FOREMPSI, FOREMPSIB, FOREMPSII, FOREMPSIS, FOREMPNO, MOPTRA, NUMTRAMOP, FORTRASI, NUMTRASI, FORTRASIB, FORTRASII, FORTRASIS, FORTRANO, NUMTRANO, MOPSPP, SEGSPP, HIGSPP, ERGSPP, MEDSPP, MOPSPA, SEGSPA, HIGSPA, ERGSPA, MEDSPA, NOMSPA, COMSEG, NUMCOMSEG1, NUMCOMSEG2, DELPRE, NUMDEL, FORPRESI, NUMDEFSI, FORPRENO, NUMDEFNO, CODMER, INDERSI, INDERNO, RIEEMP, RIETRA, RIESPP, RIEOTRO, RIESPA, DESOTRO, FIRMSI, FIRMNO, PARDELESI, PARDELENO, PARTRASI, PARTRANO, CONDELESI, CONDELENO, INFTRASI, INFTRANO, MEDPLASI, MEDPLANO, MEDRESSI, MEDRESNO, MEDFECSI, MEDFECNO, MEDPRESI, MEDPRENO, CODMED, MEDPLAACTSI, MEDPLAACTNO, CONPLATRASI, CONPLATRANO, MEDSIMUSI, MEDSIMUNO, RMEEMP, RMETRA, RMESPP, RMEOTRO, RMESPA, DESOTRO2, FORTRAPRE, VIGSAL, TRASEN, TRAMEN, TRAMAT, INFNUESI, INFNUENO, PLANACOGSI, PLANACOGNO, OBSERVACIONES) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, vdocos6.getNumexp(), vdocos6.getNumeje(),
				vdocos6.getNumvis(), vdocos6.getNomtec(), vdocos6.getCodtec(),
				vdocos6.getFechavis(), vdocos6.getFecharevi(),
				vdocos6.getNomempresa(), vdocos6.getNifempresa(),
				vdocos6.getProvssemp(), vdocos6.getNumssemp(),
				vdocos6.getDigssemp(), vdocos6.getDomicilioemp(),
				vdocos6.getCodpostalemp(), vdocos6.getCnaeemp(),
				vdocos6.getTipapersi(), vdocos6.getTipaperno(),
				vdocos6.getNumtra(), vdocos6.getDomiciliocen(),
				vdocos6.getCodpostalcen(), vdocos6.getTelcen(),
				vdocos6.getFaxcen(), vdocos6.getEmailcen(),
				vdocos6.getCodmod(), vdocos6.getMopemp(),
				vdocos6.getForempsi(), vdocos6.getForempsib(),
				vdocos6.getForempsii(), vdocos6.getForempsis(),
				vdocos6.getForempno(), vdocos6.getMoptra(),
				vdocos6.getNumtramop(), vdocos6.getFortrasi(),
				vdocos6.getNumtrasi(), vdocos6.getFortrasib(),
				vdocos6.getFortrasii(), vdocos6.getFortrasis(),
				vdocos6.getFortrano(), vdocos6.getNumtrano(),
				vdocos6.getMopspp(), vdocos6.getSegspp(), vdocos6.getHigspp(),
				vdocos6.getErgspp(), vdocos6.getMedspp(), vdocos6.getMopspa(),
				vdocos6.getSegspa(), vdocos6.getHigspa(), vdocos6.getErgspa(),
				vdocos6.getMedspa(), vdocos6.getNomspa(), vdocos6.getComseg(),
				vdocos6.getNumcomseg1(), vdocos6.getNumcomseg2(),
				vdocos6.getDelpre(), vdocos6.getNumdel(),
				vdocos6.getForpresi(), vdocos6.getNumdefsi(),
				vdocos6.getForpreno(), vdocos6.getNumdefno(),
				vdocos6.getCodmer(), vdocos6.getIndersi(),
				vdocos6.getInderno(), vdocos6.getRieemp(), vdocos6.getRietra(),
				vdocos6.getRiespp(), vdocos6.getRieotro(), vdocos6.getRiespa(),
				vdocos6.getDesotro(), vdocos6.getFirmsi(), vdocos6.getFirmno(),
				vdocos6.getPardelesi(), vdocos6.getPardeleno(),
				vdocos6.getPartrasi(), vdocos6.getPartrano(),
				vdocos6.getCondelesi(), vdocos6.getCondeleno(),
				vdocos6.getInftrasi(), vdocos6.getInftrano(),
				vdocos6.getMedplasi(), vdocos6.getMedplano(),
				vdocos6.getMedressi(), vdocos6.getMedresno(),
				vdocos6.getMedfecsi(), vdocos6.getMedfecno(),
				vdocos6.getMedpresi(), vdocos6.getMedpreno(),
				vdocos6.getCodmed(), vdocos6.getMedplaactsi(),
				vdocos6.getMedplaactno(), vdocos6.getConplatrasi(),
				vdocos6.getConplatrano(), vdocos6.getMedsimusi(),
				vdocos6.getMedsimuno(), vdocos6.getRmeemp(),
				vdocos6.getRmetra(), vdocos6.getRmespp(), vdocos6.getRmeotro(),
				vdocos6.getRmespa(), vdocos6.getDesotro2(),
				vdocos6.getFortrapre(), vdocos6.getVigsal(),
				vdocos6.getTrasen(), vdocos6.getTramen(), vdocos6.getTramat(),
				vdocos6.getInfnuesi(), vdocos6.getInfnueno(),
				vdocos6.getPlanacogsi(), vdocos6.getPlanacogno(),
				vdocos6.getObservaciones());
		return vdocos6;
	}

	/**
	 * Updates a single row in the VdocOs6 table.
	 * 
	 *  vdocos6
	 *            VdocOs6
	 *  VdocOs6
	 *
	 * @param vdocos6 the vdocos 6
	 * @return the vdoc os 6
	 */
	public VdocOs6 update(VdocOs6 vdocos6) {
		String query = "UPDATE VDOC_OS6 SET  WHERE NUMEXP=? AND NUMVIS=? AND NOMTEC=? AND CODTEC=? AND FECHAVIS=? AND FECHAREVI=? AND NOMEMPRESA=? AND NIFEMPRESA=? AND PROVSSEMP=? AND NUMSSEMP=? AND DIGSSEMP=? AND DOMICILIOEMP=? AND CODPOSTALEMP=? AND CNAEEMP=? AND TIPAPERSI=? AND TIPAPERNO=? AND NUMTRA=? AND DOMICILIOCEN=? AND CODPOSTALCEN=? AND TELCEN=? AND FAXCEN=? AND EMAILCEN=? AND CODMOD=? AND MOPEMP=? AND FOREMPSI=? AND FOREMPSIB=? AND FOREMPSII=? AND FOREMPSIS=? AND FOREMPNO=? AND MOPTRA=? AND NUMTRAMOP=? AND FORTRASI=? AND NUMTRASI=? AND FORTRASIB=? AND FORTRASII=? AND FORTRASIS=? AND FORTRANO=? AND NUMTRANO=? AND MOPSPP=? AND SEGSPP=? AND HIGSPP=? AND ERGSPP=? AND MEDSPP=? AND MOPSPA=? AND SEGSPA=? AND HIGSPA=? AND ERGSPA=? AND MEDSPA=? AND NOMSPA=? AND COMSEG=? AND NUMCOMSEG1=? AND NUMCOMSEG2=? AND DELPRE=? AND NUMDEL=? AND FORPRESI=? AND NUMDEFSI=? AND FORPRENO=? AND NUMDEFNO=? AND CODMER=? AND INDERSI=? AND INDERNO=? AND RIEEMP=? AND RIETRA=? AND RIESPP=? AND RIEOTRO=? AND RIESPA=? AND DESOTRO=? AND FIRMSI=? AND FIRMNO=? AND PARDELESI=? AND PARDELENO=? AND PARTRASI=? AND PARTRANO=? AND CONDELESI=? AND CONDELENO=? AND INFTRASI=? AND INFTRANO=? AND MEDPLASI=? AND MEDPLANO=? AND MEDRESSI=? AND MEDRESNO=? AND MEDFECSI=? AND MEDFECNO=? AND MEDPRESI=? AND MEDPRENO=? AND CODMED=? AND MEDPLAACTSI=? AND MEDPLAACTNO=? AND CONPLATRASI=? AND CONPLATRANO=? AND MEDSIMUSI=? AND MEDSIMUNO=? AND RMEEMP=? AND RMETRA=? AND RMESPP=? AND RMEOTRO=? AND RMESPA=? AND DESOTRO2=? AND FORTRAPRE=? AND VIGSAL=? AND TRASEN=? AND TRAMEN=? AND TRAMAT=? AND INFNUESI=? AND INFNUENO=? AND PLANACOGSI=? AND PLANACOGNO=? AND OBSERVACIONES=?";
		this.jdbcTemplate.update(query, vdocos6.getNumexp(),
				vdocos6.getNumvis(), vdocos6.getNomtec(), vdocos6.getCodtec(),
				vdocos6.getFechavis(), vdocos6.getFecharevi(),
				vdocos6.getNomempresa(), vdocos6.getNifempresa(),
				vdocos6.getProvssemp(), vdocos6.getNumssemp(),
				vdocos6.getDigssemp(), vdocos6.getDomicilioemp(),
				vdocos6.getCodpostalemp(), vdocos6.getCnaeemp(),
				vdocos6.getTipapersi(), vdocos6.getTipaperno(),
				vdocos6.getNumtra(), vdocos6.getDomiciliocen(),
				vdocos6.getCodpostalcen(), vdocos6.getTelcen(),
				vdocos6.getFaxcen(), vdocos6.getEmailcen(),
				vdocos6.getCodmod(), vdocos6.getMopemp(),
				vdocos6.getForempsi(), vdocos6.getForempsib(),
				vdocos6.getForempsii(), vdocos6.getForempsis(),
				vdocos6.getForempno(), vdocos6.getMoptra(),
				vdocos6.getNumtramop(), vdocos6.getFortrasi(),
				vdocos6.getNumtrasi(), vdocos6.getFortrasib(),
				vdocos6.getFortrasii(), vdocos6.getFortrasis(),
				vdocos6.getFortrano(), vdocos6.getNumtrano(),
				vdocos6.getMopspp(), vdocos6.getSegspp(), vdocos6.getHigspp(),
				vdocos6.getErgspp(), vdocos6.getMedspp(), vdocos6.getMopspa(),
				vdocos6.getSegspa(), vdocos6.getHigspa(), vdocos6.getErgspa(),
				vdocos6.getMedspa(), vdocos6.getNomspa(), vdocos6.getComseg(),
				vdocos6.getNumcomseg1(), vdocos6.getNumcomseg2(),
				vdocos6.getDelpre(), vdocos6.getNumdel(),
				vdocos6.getForpresi(), vdocos6.getNumdefsi(),
				vdocos6.getForpreno(), vdocos6.getNumdefno(),
				vdocos6.getCodmer(), vdocos6.getIndersi(),
				vdocos6.getInderno(), vdocos6.getRieemp(), vdocos6.getRietra(),
				vdocos6.getRiespp(), vdocos6.getRieotro(), vdocos6.getRiespa(),
				vdocos6.getDesotro(), vdocos6.getFirmsi(), vdocos6.getFirmno(),
				vdocos6.getPardelesi(), vdocos6.getPardeleno(),
				vdocos6.getPartrasi(), vdocos6.getPartrano(),
				vdocos6.getCondelesi(), vdocos6.getCondeleno(),
				vdocos6.getInftrasi(), vdocos6.getInftrano(),
				vdocos6.getMedplasi(), vdocos6.getMedplano(),
				vdocos6.getMedressi(), vdocos6.getMedresno(),
				vdocos6.getMedfecsi(), vdocos6.getMedfecno(),
				vdocos6.getMedpresi(), vdocos6.getMedpreno(),
				vdocos6.getCodmed(), vdocos6.getMedplaactsi(),
				vdocos6.getMedplaactno(), vdocos6.getConplatrasi(),
				vdocos6.getConplatrano(), vdocos6.getMedsimusi(),
				vdocos6.getMedsimuno(), vdocos6.getRmeemp(),
				vdocos6.getRmetra(), vdocos6.getRmespp(), vdocos6.getRmeotro(),
				vdocos6.getRmespa(), vdocos6.getDesotro2(),
				vdocos6.getFortrapre(), vdocos6.getVigsal(),
				vdocos6.getTrasen(), vdocos6.getTramen(), vdocos6.getTramat(),
				vdocos6.getInfnuesi(), vdocos6.getInfnueno(),
				vdocos6.getPlanacogsi(), vdocos6.getPlanacogno(),
				vdocos6.getObservaciones());
		return vdocos6;
	}

	/**
	 * Finds a single row in the VdocOs6 table.
	 * 
	 *  vdocos6
	 *            VdocOs6
	 *  VdocOs6
	 *
	 * @param vdocos6 the vdocos 6
	 * @return the vdoc os 6
	 */
	@Transactional(readOnly = true)
	public VdocOs6 find(VdocOs6 vdocos6) {
		String query = "SELECT t1.NUMEXP NUMEXP, t1.NUMEJE NUMEJE, t1.NUMVIS NUMVIS, t1.NOMTEC NOMTEC, t1.CODTEC CODTEC, t1.FECHAVIS FECHAVIS, t1.FECHAREVI FECHAREVI, t1.NOMEMPRESA NOMEMPRESA, t1.NIFEMPRESA NIFEMPRESA, t1.PROVSSEMP PROVSSEMP, t1.NUMSSEMP NUMSSEMP, t1.DIGSSEMP DIGSSEMP, t1.DOMICILIOEMP DOMICILIOEMP, t1.CODPOSTALEMP CODPOSTALEMP, t1.CNAEEMP CNAEEMP, t1.TIPAPERSI TIPAPERSI, t1.TIPAPERNO TIPAPERNO, t1.NUMTRA NUMTRA, t1.DOMICILIOCEN DOMICILIOCEN, t1.CODPOSTALCEN CODPOSTALCEN, t1.TELCEN TELCEN, t1.FAXCEN FAXCEN, t1.EMAILCEN EMAILCEN, t1.CODMOD CODMOD, t1.MOPEMP MOPEMP, t1.FOREMPSI FOREMPSI, t1.FOREMPSIB FOREMPSIB, t1.FOREMPSII FOREMPSII, t1.FOREMPSIS FOREMPSIS, t1.FOREMPNO FOREMPNO, t1.MOPTRA MOPTRA, t1.NUMTRAMOP NUMTRAMOP, t1.FORTRASI FORTRASI, t1.NUMTRASI NUMTRASI, t1.FORTRASIB FORTRASIB, t1.FORTRASII FORTRASII, t1.FORTRASIS FORTRASIS, t1.FORTRANO FORTRANO, t1.NUMTRANO NUMTRANO, t1.MOPSPP MOPSPP, t1.SEGSPP SEGSPP, t1.HIGSPP HIGSPP, t1.ERGSPP ERGSPP, t1.MEDSPP MEDSPP, t1.MOPSPA MOPSPA, t1.SEGSPA SEGSPA, t1.HIGSPA HIGSPA, t1.ERGSPA ERGSPA, t1.MEDSPA MEDSPA, t1.NOMSPA NOMSPA, t1.COMSEG COMSEG, t1.NUMCOMSEG1 NUMCOMSEG1, t1.NUMCOMSEG2 NUMCOMSEG2, t1.DELPRE DELPRE, t1.NUMDEL NUMDEL, t1.FORPRESI FORPRESI, t1.NUMDEFSI NUMDEFSI, t1.FORPRENO FORPRENO, t1.NUMDEFNO NUMDEFNO, t1.CODMER CODMER, t1.INDERSI INDERSI, t1.INDERNO INDERNO, t1.RIEEMP RIEEMP, t1.RIETRA RIETRA, t1.RIESPP RIESPP, t1.RIEOTRO RIEOTRO, t1.RIESPA RIESPA, t1.DESOTRO DESOTRO, t1.FIRMSI FIRMSI, t1.FIRMNO FIRMNO, t1.PARDELESI PARDELESI, t1.PARDELENO PARDELENO, t1.PARTRASI PARTRASI, t1.PARTRANO PARTRANO, t1.CONDELESI CONDELESI, t1.CONDELENO CONDELENO, t1.INFTRASI INFTRASI, t1.INFTRANO INFTRANO, t1.MEDPLASI MEDPLASI, t1.MEDPLANO MEDPLANO, t1.MEDRESSI MEDRESSI, t1.MEDRESNO MEDRESNO, t1.MEDFECSI MEDFECSI, t1.MEDFECNO MEDFECNO, t1.MEDPRESI MEDPRESI, t1.MEDPRENO MEDPRENO, t1.CODMED CODMED, t1.MEDPLAACTSI MEDPLAACTSI, t1.MEDPLAACTNO MEDPLAACTNO, t1.CONPLATRASI CONPLATRASI, t1.CONPLATRANO CONPLATRANO, t1.MEDSIMUSI MEDSIMUSI, t1.MEDSIMUNO MEDSIMUNO, t1.RMEEMP RMEEMP, t1.RMETRA RMETRA, t1.RMESPP RMESPP, t1.RMEOTRO RMEOTRO, t1.RMESPA RMESPA, t1.DESOTRO2 DESOTRO2, t1.FORTRAPRE FORTRAPRE, t1.VIGSAL VIGSAL, t1.TRASEN TRASEN, t1.TRAMEN TRAMEN, t1.TRAMAT TRAMAT, t1.INFNUESI INFNUESI, t1.INFNUENO INFNUENO, t1.PLANACOGSI PLANACOGSI, t1.PLANACOGNO PLANACOGNO, t1.OBSERVACIONES OBSERVACIONES FROM VDOC_OS6 t1  WHERE t1.NUMEXP = ? AND t1.NUMEJE = ?  ";

		List<VdocOs6> vdocos6List = this.jdbcTemplate.query(query, this.rwMap,
				vdocos6.getNumexp(), vdocos6.getNumeje());
		return (VdocOs6) DataAccessUtils.uniqueResult(vdocos6List);
	}

	/**
	 * Removes a single row in the VdocOs6 table.
	 * 
	 *  vdocos6            VdocOs6
	 *
	 * @param vdocos6 the vdocos 6
	 */
	public void remove(VdocOs6 vdocos6) {
		String query = "DELETE FROM VDOC_OS6 WHERE NUMEXP=? AND NUMEJE=? AND NUMVIS=? AND NOMTEC=? AND CODTEC=? AND FECHAVIS=? AND FECHAREVI=? AND NOMEMPRESA=? AND NIFEMPRESA=? AND PROVSSEMP=? AND NUMSSEMP=? AND DIGSSEMP=? AND DOMICILIOEMP=? AND CODPOSTALEMP=? AND CNAEEMP=? AND TIPAPERSI=? AND TIPAPERNO=? AND NUMTRA=? AND DOMICILIOCEN=? AND CODPOSTALCEN=? AND TELCEN=? AND FAXCEN=? AND EMAILCEN=? AND CODMOD=? AND MOPEMP=? AND FOREMPSI=? AND FOREMPSIB=? AND FOREMPSII=? AND FOREMPSIS=? AND FOREMPNO=? AND MOPTRA=? AND NUMTRAMOP=? AND FORTRASI=? AND NUMTRASI=? AND FORTRASIB=? AND FORTRASII=? AND FORTRASIS=? AND FORTRANO=? AND NUMTRANO=? AND MOPSPP=? AND SEGSPP=? AND HIGSPP=? AND ERGSPP=? AND MEDSPP=? AND MOPSPA=? AND SEGSPA=? AND HIGSPA=? AND ERGSPA=? AND MEDSPA=? AND NOMSPA=? AND COMSEG=? AND NUMCOMSEG1=? AND NUMCOMSEG2=? AND DELPRE=? AND NUMDEL=? AND FORPRESI=? AND NUMDEFSI=? AND FORPRENO=? AND NUMDEFNO=? AND CODMER=? AND INDERSI=? AND INDERNO=? AND RIEEMP=? AND RIETRA=? AND RIESPP=? AND RIEOTRO=? AND RIESPA=? AND DESOTRO=? AND FIRMSI=? AND FIRMNO=? AND PARDELESI=? AND PARDELENO=? AND PARTRASI=? AND PARTRANO=? AND CONDELESI=? AND CONDELENO=? AND INFTRASI=? AND INFTRANO=? AND MEDPLASI=? AND MEDPLANO=? AND MEDRESSI=? AND MEDRESNO=? AND MEDFECSI=? AND MEDFECNO=? AND MEDPRESI=? AND MEDPRENO=? AND CODMED=? AND MEDPLAACTSI=? AND MEDPLAACTNO=? AND CONPLATRASI=? AND CONPLATRANO=? AND MEDSIMUSI=? AND MEDSIMUNO=? AND RMEEMP=? AND RMETRA=? AND RMESPP=? AND RMEOTRO=? AND RMESPA=? AND DESOTRO2=? AND FORTRAPRE=? AND VIGSAL=? AND TRASEN=? AND TRAMEN=? AND TRAMAT=? AND INFNUESI=? AND INFNUENO=? AND PLANACOGSI=? AND PLANACOGNO=? AND OBSERVACIONES=?";
		this.jdbcTemplate.update(query, vdocos6.getNumexp(), vdocos6.getNumeje(),
				vdocos6.getNumvis(), vdocos6.getNomtec(), vdocos6.getCodtec(),
				vdocos6.getFechavis(), vdocos6.getFecharevi(),
				vdocos6.getNomempresa(), vdocos6.getNifempresa(),
				vdocos6.getProvssemp(), vdocos6.getNumssemp(),
				vdocos6.getDigssemp(), vdocos6.getDomicilioemp(),
				vdocos6.getCodpostalemp(), vdocos6.getCnaeemp(),
				vdocos6.getTipapersi(), vdocos6.getTipaperno(),
				vdocos6.getNumtra(), vdocos6.getDomiciliocen(),
				vdocos6.getCodpostalcen(), vdocos6.getTelcen(),
				vdocos6.getFaxcen(), vdocos6.getEmailcen(),
				vdocos6.getCodmod(), vdocos6.getMopemp(),
				vdocos6.getForempsi(), vdocos6.getForempsib(),
				vdocos6.getForempsii(), vdocos6.getForempsis(),
				vdocos6.getForempno(), vdocos6.getMoptra(),
				vdocos6.getNumtramop(), vdocos6.getFortrasi(),
				vdocos6.getNumtrasi(), vdocos6.getFortrasib(),
				vdocos6.getFortrasii(), vdocos6.getFortrasis(),
				vdocos6.getFortrano(), vdocos6.getNumtrano(),
				vdocos6.getMopspp(), vdocos6.getSegspp(), vdocos6.getHigspp(),
				vdocos6.getErgspp(), vdocos6.getMedspp(), vdocos6.getMopspa(),
				vdocos6.getSegspa(), vdocos6.getHigspa(), vdocos6.getErgspa(),
				vdocos6.getMedspa(), vdocos6.getNomspa(), vdocos6.getComseg(),
				vdocos6.getNumcomseg1(), vdocos6.getNumcomseg2(),
				vdocos6.getDelpre(), vdocos6.getNumdel(),
				vdocos6.getForpresi(), vdocos6.getNumdefsi(),
				vdocos6.getForpreno(), vdocos6.getNumdefno(),
				vdocos6.getCodmer(), vdocos6.getIndersi(),
				vdocos6.getInderno(), vdocos6.getRieemp(), vdocos6.getRietra(),
				vdocos6.getRiespp(), vdocos6.getRieotro(), vdocos6.getRiespa(),
				vdocos6.getDesotro(), vdocos6.getFirmsi(), vdocos6.getFirmno(),
				vdocos6.getPardelesi(), vdocos6.getPardeleno(),
				vdocos6.getPartrasi(), vdocos6.getPartrano(),
				vdocos6.getCondelesi(), vdocos6.getCondeleno(),
				vdocos6.getInftrasi(), vdocos6.getInftrano(),
				vdocos6.getMedplasi(), vdocos6.getMedplano(),
				vdocos6.getMedressi(), vdocos6.getMedresno(),
				vdocos6.getMedfecsi(), vdocos6.getMedfecno(),
				vdocos6.getMedpresi(), vdocos6.getMedpreno(),
				vdocos6.getCodmed(), vdocos6.getMedplaactsi(),
				vdocos6.getMedplaactno(), vdocos6.getConplatrasi(),
				vdocos6.getConplatrano(), vdocos6.getMedsimusi(),
				vdocos6.getMedsimuno(), vdocos6.getRmeemp(),
				vdocos6.getRmetra(), vdocos6.getRmespp(), vdocos6.getRmeotro(),
				vdocos6.getRmespa(), vdocos6.getDesotro2(),
				vdocos6.getFortrapre(), vdocos6.getVigsal(),
				vdocos6.getTrasen(), vdocos6.getTramen(), vdocos6.getTramat(),
				vdocos6.getInfnuesi(), vdocos6.getInfnueno(),
				vdocos6.getPlanacogsi(), vdocos6.getPlanacogno(),
				vdocos6.getObservaciones());
	}

	/**
	 * Finds a list of rows in the VdocOs6 table.
	 * 
	 *  vdocos6
	 *            VdocOs6
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VdocOs6>
	 *
	 * @param vdocos6 the vdocos 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VdocOs6> findAll(VdocOs6 vdocos6,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXP NUMEXP,t1.NUMEJE NUMEJE,t1.NUMVIS NUMVIS,t1.NOMTEC NOMTEC,t1.CODTEC CODTEC,t1.FECHAVIS FECHAVIS,t1.FECHAREVI FECHAREVI,t1.NOMEMPRESA NOMEMPRESA,t1.NIFEMPRESA NIFEMPRESA,t1.PROVSSEMP PROVSSEMP,t1.NUMSSEMP NUMSSEMP,t1.DIGSSEMP DIGSSEMP,t1.DOMICILIOEMP DOMICILIOEMP,t1.CODPOSTALEMP CODPOSTALEMP,t1.CNAEEMP CNAEEMP,t1.TIPAPERSI TIPAPERSI,t1.TIPAPERNO TIPAPERNO,t1.NUMTRA NUMTRA,t1.DOMICILIOCEN DOMICILIOCEN,t1.CODPOSTALCEN CODPOSTALCEN,t1.TELCEN TELCEN,t1.FAXCEN FAXCEN,t1.EMAILCEN EMAILCEN,t1.CODMOD CODMOD,t1.MOPEMP MOPEMP,t1.FOREMPSI FOREMPSI,t1.FOREMPSIB FOREMPSIB,t1.FOREMPSII FOREMPSII,t1.FOREMPSIS FOREMPSIS,t1.FOREMPNO FOREMPNO,t1.MOPTRA MOPTRA,t1.NUMTRAMOP NUMTRAMOP,t1.FORTRASI FORTRASI,t1.NUMTRASI NUMTRASI,t1.FORTRASIB FORTRASIB,t1.FORTRASII FORTRASII,t1.FORTRASIS FORTRASIS,t1.FORTRANO FORTRANO,t1.NUMTRANO NUMTRANO,t1.MOPSPP MOPSPP,t1.SEGSPP SEGSPP,t1.HIGSPP HIGSPP,t1.ERGSPP ERGSPP,t1.MEDSPP MEDSPP,t1.MOPSPA MOPSPA,t1.SEGSPA SEGSPA,t1.HIGSPA HIGSPA,t1.ERGSPA ERGSPA,t1.MEDSPA MEDSPA,t1.NOMSPA NOMSPA,t1.COMSEG COMSEG,t1.NUMCOMSEG1 NUMCOMSEG1,t1.NUMCOMSEG2 NUMCOMSEG2,t1.DELPRE DELPRE,t1.NUMDEL NUMDEL,t1.FORPRESI FORPRESI,t1.NUMDEFSI NUMDEFSI,t1.FORPRENO FORPRENO,t1.NUMDEFNO NUMDEFNO,t1.CODMER CODMER,t1.INDERSI INDERSI,t1.INDERNO INDERNO,t1.RIEEMP RIEEMP,t1.RIETRA RIETRA,t1.RIESPP RIESPP,t1.RIEOTRO RIEOTRO,t1.RIESPA RIESPA,t1.DESOTRO DESOTRO,t1.FIRMSI FIRMSI,t1.FIRMNO FIRMNO,t1.PARDELESI PARDELESI,t1.PARDELENO PARDELENO,t1.PARTRASI PARTRASI,t1.PARTRANO PARTRANO,t1.CONDELESI CONDELESI,t1.CONDELENO CONDELENO,t1.INFTRASI INFTRASI,t1.INFTRANO INFTRANO,t1.MEDPLASI MEDPLASI,t1.MEDPLANO MEDPLANO,t1.MEDRESSI MEDRESSI,t1.MEDRESNO MEDRESNO,t1.MEDFECSI MEDFECSI,t1.MEDFECNO MEDFECNO,t1.MEDPRESI MEDPRESI,t1.MEDPRENO MEDPRENO,t1.CODMED CODMED,t1.MEDPLAACTSI MEDPLAACTSI,t1.MEDPLAACTNO MEDPLAACTNO,t1.CONPLATRASI CONPLATRASI,t1.CONPLATRANO CONPLATRANO,t1.MEDSIMUSI MEDSIMUSI,t1.MEDSIMUNO MEDSIMUNO,t1.RMEEMP RMEEMP,t1.RMETRA RMETRA,t1.RMESPP RMESPP,t1.RMEOTRO RMEOTRO,t1.RMESPA RMESPA,t1.DESOTRO2 DESOTRO2,t1.FORTRAPRE FORTRAPRE,t1.VIGSAL VIGSAL,t1.TRASEN TRASEN,t1.TRAMEN TRAMEN,t1.TRAMAT TRAMAT,t1.INFNUESI INFNUESI,t1.INFNUENO INFNUENO,t1.PLANACOGSI PLANACOGSI,t1.PLANACOGNO PLANACOGNO,t1.OBSERVACIONES OBSERVACIONES ");
		query.append("FROM VDOC_OS6 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vdocos6);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VdocOs6>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VdocOs6 table using like.
	 * 
	 *  vdocos6
	 *            VdocOs6
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VdocOs6>
	 *
	 * @param vdocos6 the vdocos 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VdocOs6> findAllLike(VdocOs6 vdocos6,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXP NUMEXP,t1.NUMEJE NUMEJE,t1.NUMVIS NUMVIS,t1.NOMTEC NOMTEC,t1.CODTEC CODTEC,t1.FECHAVIS FECHAVIS,t1.FECHAREVI FECHAREVI,t1.NOMEMPRESA NOMEMPRESA,t1.NIFEMPRESA NIFEMPRESA,t1.PROVSSEMP PROVSSEMP,t1.NUMSSEMP NUMSSEMP,t1.DIGSSEMP DIGSSEMP,t1.DOMICILIOEMP DOMICILIOEMP,t1.CODPOSTALEMP CODPOSTALEMP,t1.CNAEEMP CNAEEMP,t1.TIPAPERSI TIPAPERSI,t1.TIPAPERNO TIPAPERNO,t1.NUMTRA NUMTRA,t1.DOMICILIOCEN DOMICILIOCEN,t1.CODPOSTALCEN CODPOSTALCEN,t1.TELCEN TELCEN,t1.FAXCEN FAXCEN,t1.EMAILCEN EMAILCEN,t1.CODMOD CODMOD,t1.MOPEMP MOPEMP,t1.FOREMPSI FOREMPSI,t1.FOREMPSIB FOREMPSIB,t1.FOREMPSII FOREMPSII,t1.FOREMPSIS FOREMPSIS,t1.FOREMPNO FOREMPNO,t1.MOPTRA MOPTRA,t1.NUMTRAMOP NUMTRAMOP,t1.FORTRASI FORTRASI,t1.NUMTRASI NUMTRASI,t1.FORTRASIB FORTRASIB,t1.FORTRASII FORTRASII,t1.FORTRASIS FORTRASIS,t1.FORTRANO FORTRANO,t1.NUMTRANO NUMTRANO,t1.MOPSPP MOPSPP,t1.SEGSPP SEGSPP,t1.HIGSPP HIGSPP,t1.ERGSPP ERGSPP,t1.MEDSPP MEDSPP,t1.MOPSPA MOPSPA,t1.SEGSPA SEGSPA,t1.HIGSPA HIGSPA,t1.ERGSPA ERGSPA,t1.MEDSPA MEDSPA,t1.NOMSPA NOMSPA,t1.COMSEG COMSEG,t1.NUMCOMSEG1 NUMCOMSEG1,t1.NUMCOMSEG2 NUMCOMSEG2,t1.DELPRE DELPRE,t1.NUMDEL NUMDEL,t1.FORPRESI FORPRESI,t1.NUMDEFSI NUMDEFSI,t1.FORPRENO FORPRENO,t1.NUMDEFNO NUMDEFNO,t1.CODMER CODMER,t1.INDERSI INDERSI,t1.INDERNO INDERNO,t1.RIEEMP RIEEMP,t1.RIETRA RIETRA,t1.RIESPP RIESPP,t1.RIEOTRO RIEOTRO,t1.RIESPA RIESPA,t1.DESOTRO DESOTRO,t1.FIRMSI FIRMSI,t1.FIRMNO FIRMNO,t1.PARDELESI PARDELESI,t1.PARDELENO PARDELENO,t1.PARTRASI PARTRASI,t1.PARTRANO PARTRANO,t1.CONDELESI CONDELESI,t1.CONDELENO CONDELENO,t1.INFTRASI INFTRASI,t1.INFTRANO INFTRANO,t1.MEDPLASI MEDPLASI,t1.MEDPLANO MEDPLANO,t1.MEDRESSI MEDRESSI,t1.MEDRESNO MEDRESNO,t1.MEDFECSI MEDFECSI,t1.MEDFECNO MEDFECNO,t1.MEDPRESI MEDPRESI,t1.MEDPRENO MEDPRENO,t1.CODMED CODMED,t1.MEDPLAACTSI MEDPLAACTSI,t1.MEDPLAACTNO MEDPLAACTNO,t1.CONPLATRASI CONPLATRASI,t1.CONPLATRANO CONPLATRANO,t1.MEDSIMUSI MEDSIMUSI,t1.MEDSIMUNO MEDSIMUNO,t1.RMEEMP RMEEMP,t1.RMETRA RMETRA,t1.RMESPP RMESPP,t1.RMEOTRO RMEOTRO,t1.RMESPA RMESPA,t1.DESOTRO2 DESOTRO2,t1.FORTRAPRE FORTRAPRE,t1.VIGSAL VIGSAL,t1.TRASEN TRASEN,t1.TRAMEN TRAMEN,t1.TRAMAT TRAMAT,t1.INFNUESI INFNUESI,t1.INFNUENO INFNUENO,t1.PLANACOGSI PLANACOGSI,t1.PLANACOGNO PLANACOGNO,t1.OBSERVACIONES OBSERVACIONES ");
		query.append("FROM VDOC_OS6 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vdocos6, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VdocOs6>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VdocOs6 table.
	 * 
	 *  vdocos6
	 *            VdocOs6
	 *  Long
	 *
	 * @param vdocos6 the vdocos 6
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VdocOs6 vdocos6) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VDOC_OS6 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vdocos6);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VdocOs6 table using like.
	 * 
	 *  vdocos6
	 *            VdocOs6
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param vdocos6 the vdocos 6
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VdocOs6 vdocos6, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VDOC_OS6 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vdocos6, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VdocOs6 selected for rup_table.
	 * 
	 *  vdocos6            VdocOs6
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VdocOs6>>
	 *
	 * @param vdocos6 the vdocos 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VdocOs6>> reorderSelection(VdocOs6 vdocos6,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.NUMEJE NUMEJE,t1.NUMVIS NUMVIS,t1.NOMTEC NOMTEC,t1.CODTEC CODTEC,t1.FECHAVIS FECHAVIS,t1.FECHAREVI FECHAREVI,t1.NOMEMPRESA NOMEMPRESA,t1.NIFEMPRESA NIFEMPRESA,t1.PROVSSEMP PROVSSEMP,t1.NUMSSEMP NUMSSEMP,t1.DIGSSEMP DIGSSEMP,t1.DOMICILIOEMP DOMICILIOEMP,t1.CODPOSTALEMP CODPOSTALEMP,t1.CNAEEMP CNAEEMP,t1.TIPAPERSI TIPAPERSI,t1.TIPAPERNO TIPAPERNO,t1.NUMTRA NUMTRA,t1.DOMICILIOCEN DOMICILIOCEN,t1.CODPOSTALCEN CODPOSTALCEN,t1.TELCEN TELCEN,t1.FAXCEN FAXCEN,t1.EMAILCEN EMAILCEN,t1.CODMOD CODMOD,t1.MOPEMP MOPEMP,t1.FOREMPSI FOREMPSI,t1.FOREMPSIB FOREMPSIB,t1.FOREMPSII FOREMPSII,t1.FOREMPSIS FOREMPSIS,t1.FOREMPNO FOREMPNO,t1.MOPTRA MOPTRA,t1.NUMTRAMOP NUMTRAMOP,t1.FORTRASI FORTRASI,t1.NUMTRASI NUMTRASI,t1.FORTRASIB FORTRASIB,t1.FORTRASII FORTRASII,t1.FORTRASIS FORTRASIS,t1.FORTRANO FORTRANO,t1.NUMTRANO NUMTRANO,t1.MOPSPP MOPSPP,t1.SEGSPP SEGSPP,t1.HIGSPP HIGSPP,t1.ERGSPP ERGSPP,t1.MEDSPP MEDSPP,t1.MOPSPA MOPSPA,t1.SEGSPA SEGSPA,t1.HIGSPA HIGSPA,t1.ERGSPA ERGSPA,t1.MEDSPA MEDSPA,t1.NOMSPA NOMSPA,t1.COMSEG COMSEG,t1.NUMCOMSEG1 NUMCOMSEG1,t1.NUMCOMSEG2 NUMCOMSEG2,t1.DELPRE DELPRE,t1.NUMDEL NUMDEL,t1.FORPRESI FORPRESI,t1.NUMDEFSI NUMDEFSI,t1.FORPRENO FORPRENO,t1.NUMDEFNO NUMDEFNO,t1.CODMER CODMER,t1.INDERSI INDERSI,t1.INDERNO INDERNO,t1.RIEEMP RIEEMP,t1.RIETRA RIETRA,t1.RIESPP RIESPP,t1.RIEOTRO RIEOTRO,t1.RIESPA RIESPA,t1.DESOTRO DESOTRO,t1.FIRMSI FIRMSI,t1.FIRMNO FIRMNO,t1.PARDELESI PARDELESI,t1.PARDELENO PARDELENO,t1.PARTRASI PARTRASI,t1.PARTRANO PARTRANO,t1.CONDELESI CONDELESI,t1.CONDELENO CONDELENO,t1.INFTRASI INFTRASI,t1.INFTRANO INFTRANO,t1.MEDPLASI MEDPLASI,t1.MEDPLANO MEDPLANO,t1.MEDRESSI MEDRESSI,t1.MEDRESNO MEDRESNO,t1.MEDFECSI MEDFECSI,t1.MEDFECNO MEDFECNO,t1.MEDPRESI MEDPRESI,t1.MEDPRENO MEDPRENO,t1.CODMED CODMED,t1.MEDPLAACTSI MEDPLAACTSI,t1.MEDPLAACTNO MEDPLAACTNO,t1.CONPLATRASI CONPLATRASI,t1.CONPLATRANO CONPLATRANO,t1.MEDSIMUSI MEDSIMUSI,t1.MEDSIMUNO MEDSIMUNO,t1.RMEEMP RMEEMP,t1.RMETRA RMETRA,t1.RMESPP RMESPP,t1.RMEOTRO RMEOTRO,t1.RMESPA RMESPA,t1.DESOTRO2 DESOTRO2,t1.FORTRAPRE FORTRAPRE,t1.VIGSAL VIGSAL,t1.TRASEN TRASEN,t1.TRAMEN TRAMEN,t1.TRAMAT TRAMAT,t1.INFNUESI INFNUESI,t1.INFNUENO INFNUENO,t1.PLANACOGSI PLANACOGSI,t1.PLANACOGNO PLANACOGNO,t1.OBSERVACIONES OBSERVACIONES ");
		// FROM
		query.append("FROM VDOC_OS6 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vdocos6, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(
						query,
						jqGridRequestDto,
						VdocOs6.class,
						filterParamList,
						"NUMEXP,NUMEJE,NUMVIS,NOMTEC,CODTEC,FECHAVIS,FECHAREVI,NOMEMPRESA,NIFEMPRESA,PROVSSEMP,NUMSSEMP,DIGSSEMP,DOMICILIOEMP,CODPOSTALEMP,CNAEEMP,TIPAPERSI,TIPAPERNO,NUMTRA,DOMICILIOCEN,CODPOSTALCEN,TELCEN,FAXCEN,EMAILCEN,CODMOD,MOPEMP,FOREMPSI,FOREMPSIB,FOREMPSII,FOREMPSIS,FOREMPNO,MOPTRA,NUMTRAMOP,FORTRASI,NUMTRASI,FORTRASIB,FORTRASII,FORTRASIS,FORTRANO,NUMTRANO,MOPSPP,SEGSPP,HIGSPP,ERGSPP,MEDSPP,MOPSPA,SEGSPA,HIGSPA,ERGSPA,MEDSPA,NOMSPA,COMSEG,NUMCOMSEG1,NUMCOMSEG2,DELPRE,NUMDEL,FORPRESI,NUMDEFSI,FORPRENO,NUMDEFNO,CODMER,INDERSI,INDERNO,RIEEMP,RIETRA,RIESPP,RIEOTRO,RIESPA,DESOTRO,FIRMSI,FIRMNO,PARDELESI,PARDELENO,PARTRASI,PARTRANO,CONDELESI,CONDELENO,INFTRASI,INFTRANO,MEDPLASI,MEDPLANO,MEDRESSI,MEDRESNO,MEDFECSI,MEDFECNO,MEDPRESI,MEDPRENO,CODMED,MEDPLAACTSI,MEDPLAACTNO,CONPLATRASI,CONPLATRANO,MEDSIMUSI,MEDSIMUNO,RMEEMP,RMETRA,RMESPP,RMEOTRO,RMESPA,DESOTRO2,FORTRAPRE,VIGSAL,TRASEN,TRAMEN,TRAMAT,INFNUESI,INFNUENO,PLANACOGSI,PLANACOGNO,OBSERVACIONES");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VdocOs6>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            VdocOs6
	 *  searchParams            VdocOs6
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VdocOs6>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VdocOs6>> search(VdocOs6 filterParams,
			VdocOs6 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.NUMEJE NUMEJE,t1.NUMVIS NUMVIS,t1.NOMTEC NOMTEC,t1.CODTEC CODTEC,t1.FECHAVIS FECHAVIS,t1.FECHAREVI FECHAREVI,t1.NOMEMPRESA NOMEMPRESA,t1.NIFEMPRESA NIFEMPRESA,t1.PROVSSEMP PROVSSEMP,t1.NUMSSEMP NUMSSEMP,t1.DIGSSEMP DIGSSEMP,t1.DOMICILIOEMP DOMICILIOEMP,t1.CODPOSTALEMP CODPOSTALEMP,t1.CNAEEMP CNAEEMP,t1.TIPAPERSI TIPAPERSI,t1.TIPAPERNO TIPAPERNO,t1.NUMTRA NUMTRA,t1.DOMICILIOCEN DOMICILIOCEN,t1.CODPOSTALCEN CODPOSTALCEN,t1.TELCEN TELCEN,t1.FAXCEN FAXCEN,t1.EMAILCEN EMAILCEN,t1.CODMOD CODMOD,t1.MOPEMP MOPEMP,t1.FOREMPSI FOREMPSI,t1.FOREMPSIB FOREMPSIB,t1.FOREMPSII FOREMPSII,t1.FOREMPSIS FOREMPSIS,t1.FOREMPNO FOREMPNO,t1.MOPTRA MOPTRA,t1.NUMTRAMOP NUMTRAMOP,t1.FORTRASI FORTRASI,t1.NUMTRASI NUMTRASI,t1.FORTRASIB FORTRASIB,t1.FORTRASII FORTRASII,t1.FORTRASIS FORTRASIS,t1.FORTRANO FORTRANO,t1.NUMTRANO NUMTRANO,t1.MOPSPP MOPSPP,t1.SEGSPP SEGSPP,t1.HIGSPP HIGSPP,t1.ERGSPP ERGSPP,t1.MEDSPP MEDSPP,t1.MOPSPA MOPSPA,t1.SEGSPA SEGSPA,t1.HIGSPA HIGSPA,t1.ERGSPA ERGSPA,t1.MEDSPA MEDSPA,t1.NOMSPA NOMSPA,t1.COMSEG COMSEG,t1.NUMCOMSEG1 NUMCOMSEG1,t1.NUMCOMSEG2 NUMCOMSEG2,t1.DELPRE DELPRE,t1.NUMDEL NUMDEL,t1.FORPRESI FORPRESI,t1.NUMDEFSI NUMDEFSI,t1.FORPRENO FORPRENO,t1.NUMDEFNO NUMDEFNO,t1.CODMER CODMER,t1.INDERSI INDERSI,t1.INDERNO INDERNO,t1.RIEEMP RIEEMP,t1.RIETRA RIETRA,t1.RIESPP RIESPP,t1.RIEOTRO RIEOTRO,t1.RIESPA RIESPA,t1.DESOTRO DESOTRO,t1.FIRMSI FIRMSI,t1.FIRMNO FIRMNO,t1.PARDELESI PARDELESI,t1.PARDELENO PARDELENO,t1.PARTRASI PARTRASI,t1.PARTRANO PARTRANO,t1.CONDELESI CONDELESI,t1.CONDELENO CONDELENO,t1.INFTRASI INFTRASI,t1.INFTRANO INFTRANO,t1.MEDPLASI MEDPLASI,t1.MEDPLANO MEDPLANO,t1.MEDRESSI MEDRESSI,t1.MEDRESNO MEDRESNO,t1.MEDFECSI MEDFECSI,t1.MEDFECNO MEDFECNO,t1.MEDPRESI MEDPRESI,t1.MEDPRENO MEDPRENO,t1.CODMED CODMED,t1.MEDPLAACTSI MEDPLAACTSI,t1.MEDPLAACTNO MEDPLAACTNO,t1.CONPLATRASI CONPLATRASI,t1.CONPLATRANO CONPLATRANO,t1.MEDSIMUSI MEDSIMUSI,t1.MEDSIMUNO MEDSIMUNO,t1.RMEEMP RMEEMP,t1.RMETRA RMETRA,t1.RMESPP RMESPP,t1.RMEOTRO RMEOTRO,t1.RMESPA RMESPA,t1.DESOTRO2 DESOTRO2,t1.FORTRAPRE FORTRAPRE,t1.VIGSAL VIGSAL,t1.TRASEN TRASEN,t1.TRAMEN TRAMEN,t1.TRAMAT TRAMAT,t1.INFNUESI INFNUESI,t1.INFNUENO INFNUENO,t1.PLANACOGSI PLANACOGSI,t1.PLANACOGNO PLANACOGNO,t1.OBSERVACIONES OBSERVACIONES ");
		// FROM
		query.append("FROM VDOC_OS6 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(
						query,
						jqGridRequestDto,
						VdocOs6.class,
						filterParamList,
						searchSQL,
						searchParamList,
						from_alias,
						"NUMEXP,NUMEJE,NUMVIS,NOMTEC,CODTEC,FECHAVIS,FECHAREVI,NOMEMPRESA,NIFEMPRESA,PROVSSEMP,NUMSSEMP,DIGSSEMP,DOMICILIOEMP,CODPOSTALEMP,CNAEEMP,TIPAPERSI,TIPAPERNO,NUMTRA,DOMICILIOCEN,CODPOSTALCEN,TELCEN,FAXCEN,EMAILCEN,CODMOD,MOPEMP,FOREMPSI,FOREMPSIB,FOREMPSII,FOREMPSIS,FOREMPNO,MOPTRA,NUMTRAMOP,FORTRASI,NUMTRASI,FORTRASIB,FORTRASII,FORTRASIS,FORTRANO,NUMTRANO,MOPSPP,SEGSPP,HIGSPP,ERGSPP,MEDSPP,MOPSPA,SEGSPA,HIGSPA,ERGSPA,MEDSPA,NOMSPA,COMSEG,NUMCOMSEG1,NUMCOMSEG2,DELPRE,NUMDEL,FORPRESI,NUMDEFSI,FORPRENO,NUMDEFNO,CODMER,INDERSI,INDERNO,RIEEMP,RIETRA,RIESPP,RIEOTRO,RIESPA,DESOTRO,FIRMSI,FIRMNO,PARDELESI,PARDELENO,PARTRASI,PARTRANO,CONDELESI,CONDELENO,INFTRASI,INFTRANO,MEDPLASI,MEDPLANO,MEDRESSI,MEDRESNO,MEDFECSI,MEDFECNO,MEDPRESI,MEDPRENO,CODMED,MEDPLAACTSI,MEDPLAACTNO,CONPLATRASI,CONPLATRANO,MEDSIMUSI,MEDSIMUNO,RMEEMP,RMETRA,RMESPP,RMEOTRO,RMESPA,DESOTRO2,FORTRAPRE,VIGSAL,TRASEN,TRAMEN,TRAMAT,INFNUESI,INFNUENO,PLANACOGSI,PLANACOGNO,OBSERVACIONES");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VdocOs6>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filtervdocos6            VdocOs6
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filtervdocos6 the filtervdocos 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(VdocOs6 filtervdocos6,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.NUMEJE NUMEJE,t1.NUMVIS NUMVIS,t1.NOMTEC NOMTEC,t1.CODTEC CODTEC,t1.FECHAVIS FECHAVIS,t1.FECHAREVI FECHAREVI,t1.NOMEMPRESA NOMEMPRESA,t1.NIFEMPRESA NIFEMPRESA,t1.PROVSSEMP PROVSSEMP,t1.NUMSSEMP NUMSSEMP,t1.DIGSSEMP DIGSSEMP,t1.DOMICILIOEMP DOMICILIOEMP,t1.CODPOSTALEMP CODPOSTALEMP,t1.CNAEEMP CNAEEMP,t1.TIPAPERSI TIPAPERSI,t1.TIPAPERNO TIPAPERNO,t1.NUMTRA NUMTRA,t1.DOMICILIOCEN DOMICILIOCEN,t1.CODPOSTALCEN CODPOSTALCEN,t1.TELCEN TELCEN,t1.FAXCEN FAXCEN,t1.EMAILCEN EMAILCEN,t1.CODMOD CODMOD,t1.MOPEMP MOPEMP,t1.FOREMPSI FOREMPSI,t1.FOREMPSIB FOREMPSIB,t1.FOREMPSII FOREMPSII,t1.FOREMPSIS FOREMPSIS,t1.FOREMPNO FOREMPNO,t1.MOPTRA MOPTRA,t1.NUMTRAMOP NUMTRAMOP,t1.FORTRASI FORTRASI,t1.NUMTRASI NUMTRASI,t1.FORTRASIB FORTRASIB,t1.FORTRASII FORTRASII,t1.FORTRASIS FORTRASIS,t1.FORTRANO FORTRANO,t1.NUMTRANO NUMTRANO,t1.MOPSPP MOPSPP,t1.SEGSPP SEGSPP,t1.HIGSPP HIGSPP,t1.ERGSPP ERGSPP,t1.MEDSPP MEDSPP,t1.MOPSPA MOPSPA,t1.SEGSPA SEGSPA,t1.HIGSPA HIGSPA,t1.ERGSPA ERGSPA,t1.MEDSPA MEDSPA,t1.NOMSPA NOMSPA,t1.COMSEG COMSEG,t1.NUMCOMSEG1 NUMCOMSEG1,t1.NUMCOMSEG2 NUMCOMSEG2,t1.DELPRE DELPRE,t1.NUMDEL NUMDEL,t1.FORPRESI FORPRESI,t1.NUMDEFSI NUMDEFSI,t1.FORPRENO FORPRENO,t1.NUMDEFNO NUMDEFNO,t1.CODMER CODMER,t1.INDERSI INDERSI,t1.INDERNO INDERNO,t1.RIEEMP RIEEMP,t1.RIETRA RIETRA,t1.RIESPP RIESPP,t1.RIEOTRO RIEOTRO,t1.RIESPA RIESPA,t1.DESOTRO DESOTRO,t1.FIRMSI FIRMSI,t1.FIRMNO FIRMNO,t1.PARDELESI PARDELESI,t1.PARDELENO PARDELENO,t1.PARTRASI PARTRASI,t1.PARTRANO PARTRANO,t1.CONDELESI CONDELESI,t1.CONDELENO CONDELENO,t1.INFTRASI INFTRASI,t1.INFTRANO INFTRANO,t1.MEDPLASI MEDPLASI,t1.MEDPLANO MEDPLANO,t1.MEDRESSI MEDRESSI,t1.MEDRESNO MEDRESNO,t1.MEDFECSI MEDFECSI,t1.MEDFECNO MEDFECNO,t1.MEDPRESI MEDPRESI,t1.MEDPRENO MEDPRENO,t1.CODMED CODMED,t1.MEDPLAACTSI MEDPLAACTSI,t1.MEDPLAACTNO MEDPLAACTNO,t1.CONPLATRASI CONPLATRASI,t1.CONPLATRANO CONPLATRANO,t1.MEDSIMUSI MEDSIMUSI,t1.MEDSIMUNO MEDSIMUNO,t1.RMEEMP RMEEMP,t1.RMETRA RMETRA,t1.RMESPP RMESPP,t1.RMEOTRO RMEOTRO,t1.RMESPA RMESPA,t1.DESOTRO2 DESOTRO2,t1.FORTRAPRE FORTRAPRE,t1.VIGSAL VIGSAL,t1.TRASEN TRASEN,t1.TRAMEN TRAMEN,t1.TRAMAT TRAMAT,t1.INFNUESI INFNUESI,t1.INFNUENO INFNUENO,t1.PLANACOGSI PLANACOGSI,t1.PLANACOGNO PLANACOGNO,t1.OBSERVACIONES OBSERVACIONES ");
		// FROM
		query.append("FROM VDOC_OS6 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtervdocos6,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(
						jqGridRequestDto,
						VdocOs6.class,
						query,
						params,
						"NUMEXP,NUMEJE,NUMVIS,NOMTEC,CODTEC,FECHAVIS,FECHAREVI,NOMEMPRESA,NIFEMPRESA,PROVSSEMP,NUMSSEMP,DIGSSEMP,DOMICILIOEMP,CODPOSTALEMP,CNAEEMP,TIPAPERSI,TIPAPERNO,NUMTRA,DOMICILIOCEN,CODPOSTALCEN,TELCEN,FAXCEN,EMAILCEN,CODMOD,MOPEMP,FOREMPSI,FOREMPSIB,FOREMPSII,FOREMPSIS,FOREMPNO,MOPTRA,NUMTRAMOP,FORTRASI,NUMTRASI,FORTRASIB,FORTRASII,FORTRASIS,FORTRANO,NUMTRANO,MOPSPP,SEGSPP,HIGSPP,ERGSPP,MEDSPP,MOPSPA,SEGSPA,HIGSPA,ERGSPA,MEDSPA,NOMSPA,COMSEG,NUMCOMSEG1,NUMCOMSEG2,DELPRE,NUMDEL,FORPRESI,NUMDEFSI,FORPRENO,NUMDEFNO,CODMER,INDERSI,INDERNO,RIEEMP,RIETRA,RIESPP,RIEOTRO,RIESPA,DESOTRO,FIRMSI,FIRMNO,PARDELESI,PARDELENO,PARTRASI,PARTRANO,CONDELESI,CONDELENO,INFTRASI,INFTRANO,MEDPLASI,MEDPLANO,MEDRESSI,MEDRESNO,MEDFECSI,MEDFECNO,MEDPRESI,MEDPRENO,CODMED,MEDPLAACTSI,MEDPLAACTNO,CONPLATRASI,CONPLATRANO,MEDSIMUSI,MEDSIMUNO,RMEEMP,RMETRA,RMESPP,RMEOTRO,RMESPA,DESOTRO2,FORTRAPRE,VIGSAL,TRASEN,TRAMEN,TRAMAT,INFNUESI,INFNUENO,PLANACOGSI,PLANACOGNO,OBSERVACIONES");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VdocOs6 entity.
	 * 
	 *  vdocos6            VdocOs6 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vdocos6 the vdocos 6
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(VdocOs6 vdocos6) {

		StringBuilder where = new StringBuilder(
				VdocOs6DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vdocos6 != null && vdocos6.getNumexp() != null) {
			where.append(" AND t1.NUMEXP = ?");
			params.add(vdocos6.getNumexp());
		}
		if (vdocos6 != null && vdocos6.getNumeje() != null) {
			where.append(" AND t1.NUMEJE = ?");
			params.add(vdocos6.getNumeje());
		}
		if (vdocos6 != null && vdocos6.getNumvis() != null) {
			where.append(" AND t1.NUMVIS = ?");
			params.add(vdocos6.getNumvis());
		}
		if (vdocos6 != null && vdocos6.getNomtec() != null) {
			where.append(" AND t1.NOMTEC = ?");
			params.add(vdocos6.getNomtec());
		}
		if (vdocos6 != null && vdocos6.getCodtec() != null) {
			where.append(" AND t1.CODTEC = ?");
			params.add(vdocos6.getCodtec());
		}
		if (vdocos6 != null && vdocos6.getFechavis() != null) {
			where.append(" AND t1.FECHAVIS = ?");
			params.add(vdocos6.getFechavis());
		}
		if (vdocos6 != null && vdocos6.getFecharevi() != null) {
			where.append(" AND t1.FECHAREVI = ?");
			params.add(vdocos6.getFecharevi());
		}
		if (vdocos6 != null && vdocos6.getNomempresa() != null) {
			where.append(" AND t1.NOMEMPRESA = ?");
			params.add(vdocos6.getNomempresa());
		}
		if (vdocos6 != null && vdocos6.getNifempresa() != null) {
			where.append(" AND t1.NIFEMPRESA = ?");
			params.add(vdocos6.getNifempresa());
		}
		if (vdocos6 != null && vdocos6.getProvssemp() != null) {
			where.append(" AND t1.PROVSSEMP = ?");
			params.add(vdocos6.getProvssemp());
		}
		if (vdocos6 != null && vdocos6.getNumssemp() != null) {
			where.append(" AND t1.NUMSSEMP = ?");
			params.add(vdocos6.getNumssemp());
		}
		if (vdocos6 != null && vdocos6.getDigssemp() != null) {
			where.append(" AND t1.DIGSSEMP = ?");
			params.add(vdocos6.getDigssemp());
		}
		if (vdocos6 != null && vdocos6.getDomicilioemp() != null) {
			where.append(" AND t1.DOMICILIOEMP = ?");
			params.add(vdocos6.getDomicilioemp());
		}
		if (vdocos6 != null && vdocos6.getCodpostalemp() != null) {
			where.append(" AND t1.CODPOSTALEMP = ?");
			params.add(vdocos6.getCodpostalemp());
		}
		if (vdocos6 != null && vdocos6.getCnaeemp() != null) {
			where.append(" AND t1.CNAEEMP = ?");
			params.add(vdocos6.getCnaeemp());
		}
		if (vdocos6 != null && vdocos6.getTipapersi() != null) {
			where.append(" AND t1.TIPAPERSI = ?");
			params.add(vdocos6.getTipapersi());
		}
		if (vdocos6 != null && vdocos6.getTipaperno() != null) {
			where.append(" AND t1.TIPAPERNO = ?");
			params.add(vdocos6.getTipaperno());
		}
		if (vdocos6 != null && vdocos6.getNumtra() != null) {
			where.append(" AND t1.NUMTRA = ?");
			params.add(vdocos6.getNumtra());
		}
		if (vdocos6 != null && vdocos6.getDomiciliocen() != null) {
			where.append(" AND t1.DOMICILIOCEN = ?");
			params.add(vdocos6.getDomiciliocen());
		}
		if (vdocos6 != null && vdocos6.getCodpostalcen() != null) {
			where.append(" AND t1.CODPOSTALCEN = ?");
			params.add(vdocos6.getCodpostalcen());
		}
		if (vdocos6 != null && vdocos6.getTelcen() != null) {
			where.append(" AND t1.TELCEN = ?");
			params.add(vdocos6.getTelcen());
		}
		if (vdocos6 != null && vdocos6.getFaxcen() != null) {
			where.append(" AND t1.FAXCEN = ?");
			params.add(vdocos6.getFaxcen());
		}
		if (vdocos6 != null && vdocos6.getEmailcen() != null) {
			where.append(" AND t1.EMAILCEN = ?");
			params.add(vdocos6.getEmailcen());
		}
		if (vdocos6 != null && vdocos6.getCodmod() != null) {
			where.append(" AND t1.CODMOD = ?");
			params.add(vdocos6.getCodmod());
		}
		if (vdocos6 != null && vdocos6.getMopemp() != null) {
			where.append(" AND t1.MOPEMP = ?");
			params.add(vdocos6.getMopemp());
		}
		if (vdocos6 != null && vdocos6.getForempsi() != null) {
			where.append(" AND t1.FOREMPSI = ?");
			params.add(vdocos6.getForempsi());
		}
		if (vdocos6 != null && vdocos6.getForempsib() != null) {
			where.append(" AND t1.FOREMPSIB = ?");
			params.add(vdocos6.getForempsib());
		}
		if (vdocos6 != null && vdocos6.getForempsii() != null) {
			where.append(" AND t1.FOREMPSII = ?");
			params.add(vdocos6.getForempsii());
		}
		if (vdocos6 != null && vdocos6.getForempsis() != null) {
			where.append(" AND t1.FOREMPSIS = ?");
			params.add(vdocos6.getForempsis());
		}
		if (vdocos6 != null && vdocos6.getForempno() != null) {
			where.append(" AND t1.FOREMPNO = ?");
			params.add(vdocos6.getForempno());
		}
		if (vdocos6 != null && vdocos6.getMoptra() != null) {
			where.append(" AND t1.MOPTRA = ?");
			params.add(vdocos6.getMoptra());
		}
		if (vdocos6 != null && vdocos6.getNumtramop() != null) {
			where.append(" AND t1.NUMTRAMOP = ?");
			params.add(vdocos6.getNumtramop());
		}
		if (vdocos6 != null && vdocos6.getFortrasi() != null) {
			where.append(" AND t1.FORTRASI = ?");
			params.add(vdocos6.getFortrasi());
		}
		if (vdocos6 != null && vdocos6.getNumtrasi() != null) {
			where.append(" AND t1.NUMTRASI = ?");
			params.add(vdocos6.getNumtrasi());
		}
		if (vdocos6 != null && vdocos6.getFortrasib() != null) {
			where.append(" AND t1.FORTRASIB = ?");
			params.add(vdocos6.getFortrasib());
		}
		if (vdocos6 != null && vdocos6.getFortrasii() != null) {
			where.append(" AND t1.FORTRASII = ?");
			params.add(vdocos6.getFortrasii());
		}
		if (vdocos6 != null && vdocos6.getFortrasis() != null) {
			where.append(" AND t1.FORTRASIS = ?");
			params.add(vdocos6.getFortrasis());
		}
		if (vdocos6 != null && vdocos6.getFortrano() != null) {
			where.append(" AND t1.FORTRANO = ?");
			params.add(vdocos6.getFortrano());
		}
		if (vdocos6 != null && vdocos6.getNumtrano() != null) {
			where.append(" AND t1.NUMTRANO = ?");
			params.add(vdocos6.getNumtrano());
		}
		if (vdocos6 != null && vdocos6.getMopspp() != null) {
			where.append(" AND t1.MOPSPP = ?");
			params.add(vdocos6.getMopspp());
		}
		if (vdocos6 != null && vdocos6.getSegspp() != null) {
			where.append(" AND t1.SEGSPP = ?");
			params.add(vdocos6.getSegspp());
		}
		if (vdocos6 != null && vdocos6.getHigspp() != null) {
			where.append(" AND t1.HIGSPP = ?");
			params.add(vdocos6.getHigspp());
		}
		if (vdocos6 != null && vdocos6.getErgspp() != null) {
			where.append(" AND t1.ERGSPP = ?");
			params.add(vdocos6.getErgspp());
		}
		if (vdocos6 != null && vdocos6.getMedspp() != null) {
			where.append(" AND t1.MEDSPP = ?");
			params.add(vdocos6.getMedspp());
		}
		if (vdocos6 != null && vdocos6.getMopspa() != null) {
			where.append(" AND t1.MOPSPA = ?");
			params.add(vdocos6.getMopspa());
		}
		if (vdocos6 != null && vdocos6.getSegspa() != null) {
			where.append(" AND t1.SEGSPA = ?");
			params.add(vdocos6.getSegspa());
		}
		if (vdocos6 != null && vdocos6.getHigspa() != null) {
			where.append(" AND t1.HIGSPA = ?");
			params.add(vdocos6.getHigspa());
		}
		if (vdocos6 != null && vdocos6.getErgspa() != null) {
			where.append(" AND t1.ERGSPA = ?");
			params.add(vdocos6.getErgspa());
		}
		if (vdocos6 != null && vdocos6.getMedspa() != null) {
			where.append(" AND t1.MEDSPA = ?");
			params.add(vdocos6.getMedspa());
		}
		if (vdocos6 != null && vdocos6.getNomspa() != null) {
			where.append(" AND t1.NOMSPA = ?");
			params.add(vdocos6.getNomspa());
		}
		if (vdocos6 != null && vdocos6.getComseg() != null) {
			where.append(" AND t1.COMSEG = ?");
			params.add(vdocos6.getComseg());
		}
		if (vdocos6 != null && vdocos6.getNumcomseg1() != null) {
			where.append(" AND t1.NUMCOMSEG1 = ?");
			params.add(vdocos6.getNumcomseg1());
		}
		if (vdocos6 != null && vdocos6.getNumcomseg2() != null) {
			where.append(" AND t1.NUMCOMSEG2 = ?");
			params.add(vdocos6.getNumcomseg2());
		}
		if (vdocos6 != null && vdocos6.getDelpre() != null) {
			where.append(" AND t1.DELPRE = ?");
			params.add(vdocos6.getDelpre());
		}
		if (vdocos6 != null && vdocos6.getNumdel() != null) {
			where.append(" AND t1.NUMDEL = ?");
			params.add(vdocos6.getNumdel());
		}
		if (vdocos6 != null && vdocos6.getForpresi() != null) {
			where.append(" AND t1.FORPRESI = ?");
			params.add(vdocos6.getForpresi());
		}
		if (vdocos6 != null && vdocos6.getNumdefsi() != null) {
			where.append(" AND t1.NUMDEFSI = ?");
			params.add(vdocos6.getNumdefsi());
		}
		if (vdocos6 != null && vdocos6.getForpreno() != null) {
			where.append(" AND t1.FORPRENO = ?");
			params.add(vdocos6.getForpreno());
		}
		if (vdocos6 != null && vdocos6.getNumdefno() != null) {
			where.append(" AND t1.NUMDEFNO = ?");
			params.add(vdocos6.getNumdefno());
		}
		if (vdocos6 != null && vdocos6.getCodmer() != null) {
			where.append(" AND t1.CODMER = ?");
			params.add(vdocos6.getCodmer());
		}
		if (vdocos6 != null && vdocos6.getIndersi() != null) {
			where.append(" AND t1.INDERSI = ?");
			params.add(vdocos6.getIndersi());
		}
		if (vdocos6 != null && vdocos6.getInderno() != null) {
			where.append(" AND t1.INDERNO = ?");
			params.add(vdocos6.getInderno());
		}
		if (vdocos6 != null && vdocos6.getRieemp() != null) {
			where.append(" AND t1.RIEEMP = ?");
			params.add(vdocos6.getRieemp());
		}
		if (vdocos6 != null && vdocos6.getRietra() != null) {
			where.append(" AND t1.RIETRA = ?");
			params.add(vdocos6.getRietra());
		}
		if (vdocos6 != null && vdocos6.getRiespp() != null) {
			where.append(" AND t1.RIESPP = ?");
			params.add(vdocos6.getRiespp());
		}
		if (vdocos6 != null && vdocos6.getRieotro() != null) {
			where.append(" AND t1.RIEOTRO = ?");
			params.add(vdocos6.getRieotro());
		}
		if (vdocos6 != null && vdocos6.getRiespa() != null) {
			where.append(" AND t1.RIESPA = ?");
			params.add(vdocos6.getRiespa());
		}
		if (vdocos6 != null && vdocos6.getDesotro() != null) {
			where.append(" AND t1.DESOTRO = ?");
			params.add(vdocos6.getDesotro());
		}
		if (vdocos6 != null && vdocos6.getFirmsi() != null) {
			where.append(" AND t1.FIRMSI = ?");
			params.add(vdocos6.getFirmsi());
		}
		if (vdocos6 != null && vdocos6.getFirmno() != null) {
			where.append(" AND t1.FIRMNO = ?");
			params.add(vdocos6.getFirmno());
		}
		if (vdocos6 != null && vdocos6.getPardelesi() != null) {
			where.append(" AND t1.PARDELESI = ?");
			params.add(vdocos6.getPardelesi());
		}
		if (vdocos6 != null && vdocos6.getPardeleno() != null) {
			where.append(" AND t1.PARDELENO = ?");
			params.add(vdocos6.getPardeleno());
		}
		if (vdocos6 != null && vdocos6.getPartrasi() != null) {
			where.append(" AND t1.PARTRASI = ?");
			params.add(vdocos6.getPartrasi());
		}
		if (vdocos6 != null && vdocos6.getPartrano() != null) {
			where.append(" AND t1.PARTRANO = ?");
			params.add(vdocos6.getPartrano());
		}
		if (vdocos6 != null && vdocos6.getCondelesi() != null) {
			where.append(" AND t1.CONDELESI = ?");
			params.add(vdocos6.getCondelesi());
		}
		if (vdocos6 != null && vdocos6.getCondeleno() != null) {
			where.append(" AND t1.CONDELENO = ?");
			params.add(vdocos6.getCondeleno());
		}
		if (vdocos6 != null && vdocos6.getInftrasi() != null) {
			where.append(" AND t1.INFTRASI = ?");
			params.add(vdocos6.getInftrasi());
		}
		if (vdocos6 != null && vdocos6.getInftrano() != null) {
			where.append(" AND t1.INFTRANO = ?");
			params.add(vdocos6.getInftrano());
		}
		if (vdocos6 != null && vdocos6.getMedplasi() != null) {
			where.append(" AND t1.MEDPLASI = ?");
			params.add(vdocos6.getMedplasi());
		}
		if (vdocos6 != null && vdocos6.getMedplano() != null) {
			where.append(" AND t1.MEDPLANO = ?");
			params.add(vdocos6.getMedplano());
		}
		if (vdocos6 != null && vdocos6.getMedressi() != null) {
			where.append(" AND t1.MEDRESSI = ?");
			params.add(vdocos6.getMedressi());
		}
		if (vdocos6 != null && vdocos6.getMedresno() != null) {
			where.append(" AND t1.MEDRESNO = ?");
			params.add(vdocos6.getMedresno());
		}
		if (vdocos6 != null && vdocos6.getMedfecsi() != null) {
			where.append(" AND t1.MEDFECSI = ?");
			params.add(vdocos6.getMedfecsi());
		}
		if (vdocos6 != null && vdocos6.getMedfecno() != null) {
			where.append(" AND t1.MEDFECNO = ?");
			params.add(vdocos6.getMedfecno());
		}
		if (vdocos6 != null && vdocos6.getMedpresi() != null) {
			where.append(" AND t1.MEDPRESI = ?");
			params.add(vdocos6.getMedpresi());
		}
		if (vdocos6 != null && vdocos6.getMedpreno() != null) {
			where.append(" AND t1.MEDPRENO = ?");
			params.add(vdocos6.getMedpreno());
		}
		if (vdocos6 != null && vdocos6.getCodmed() != null) {
			where.append(" AND t1.CODMED = ?");
			params.add(vdocos6.getCodmed());
		}
		if (vdocos6 != null && vdocos6.getMedplaactsi() != null) {
			where.append(" AND t1.MEDPLAACTSI = ?");
			params.add(vdocos6.getMedplaactsi());
		}
		if (vdocos6 != null && vdocos6.getMedplaactno() != null) {
			where.append(" AND t1.MEDPLAACTNO = ?");
			params.add(vdocos6.getMedplaactno());
		}
		if (vdocos6 != null && vdocos6.getConplatrasi() != null) {
			where.append(" AND t1.CONPLATRASI = ?");
			params.add(vdocos6.getConplatrasi());
		}
		if (vdocos6 != null && vdocos6.getConplatrano() != null) {
			where.append(" AND t1.CONPLATRANO = ?");
			params.add(vdocos6.getConplatrano());
		}
		if (vdocos6 != null && vdocos6.getMedsimusi() != null) {
			where.append(" AND t1.MEDSIMUSI = ?");
			params.add(vdocos6.getMedsimusi());
		}
		if (vdocos6 != null && vdocos6.getMedsimuno() != null) {
			where.append(" AND t1.MEDSIMUNO = ?");
			params.add(vdocos6.getMedsimuno());
		}
		if (vdocos6 != null && vdocos6.getRmeemp() != null) {
			where.append(" AND t1.RMEEMP = ?");
			params.add(vdocos6.getRmeemp());
		}
		if (vdocos6 != null && vdocos6.getRmetra() != null) {
			where.append(" AND t1.RMETRA = ?");
			params.add(vdocos6.getRmetra());
		}
		if (vdocos6 != null && vdocos6.getRmespp() != null) {
			where.append(" AND t1.RMESPP = ?");
			params.add(vdocos6.getRmespp());
		}
		if (vdocos6 != null && vdocos6.getRmeotro() != null) {
			where.append(" AND t1.RMEOTRO = ?");
			params.add(vdocos6.getRmeotro());
		}
		if (vdocos6 != null && vdocos6.getRmespa() != null) {
			where.append(" AND t1.RMESPA = ?");
			params.add(vdocos6.getRmespa());
		}
		if (vdocos6 != null && vdocos6.getDesotro2() != null) {
			where.append(" AND t1.DESOTRO2 = ?");
			params.add(vdocos6.getDesotro2());
		}
		if (vdocos6 != null && vdocos6.getFortrapre() != null) {
			where.append(" AND t1.FORTRAPRE = ?");
			params.add(vdocos6.getFortrapre());
		}
		if (vdocos6 != null && vdocos6.getVigsal() != null) {
			where.append(" AND t1.VIGSAL = ?");
			params.add(vdocos6.getVigsal());
		}
		if (vdocos6 != null && vdocos6.getTrasen() != null) {
			where.append(" AND t1.TRASEN = ?");
			params.add(vdocos6.getTrasen());
		}
		if (vdocos6 != null && vdocos6.getTramen() != null) {
			where.append(" AND t1.TRAMEN = ?");
			params.add(vdocos6.getTramen());
		}
		if (vdocos6 != null && vdocos6.getTramat() != null) {
			where.append(" AND t1.TRAMAT = ?");
			params.add(vdocos6.getTramat());
		}
		if (vdocos6 != null && vdocos6.getInfnuesi() != null) {
			where.append(" AND t1.INFNUESI = ?");
			params.add(vdocos6.getInfnuesi());
		}
		if (vdocos6 != null && vdocos6.getInfnueno() != null) {
			where.append(" AND t1.INFNUENO = ?");
			params.add(vdocos6.getInfnueno());
		}
		if (vdocos6 != null && vdocos6.getPlanacogsi() != null) {
			where.append(" AND t1.PLANACOGSI = ?");
			params.add(vdocos6.getPlanacogsi());
		}
		if (vdocos6 != null && vdocos6.getPlanacogno() != null) {
			where.append(" AND t1.PLANACOGNO = ?");
			params.add(vdocos6.getPlanacogno());
		}
		if (vdocos6 != null && vdocos6.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(vdocos6.getObservaciones());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VdocOs6 entity.
	 * 
	 *  vdocos6            VdocOs6 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vdocos6 the vdocos 6
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(VdocOs6 vdocos6,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VdocOs6DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vdocos6 != null && vdocos6.getNumexp() != null) {
			where.append(" AND UPPER(t1.NUMEXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getNumexp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getNumexp().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMEXP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getNumeje() != null) {
			where.append(" AND t1.NUMEJE = ?");
			params.add(vdocos6.getNumeje());
		}
		if (vdocos6 != null && vdocos6.getNumvis() != null) {
			where.append(" AND t1.NUMVIS = ?");
			params.add(vdocos6.getNumvis());
		}
		if (vdocos6 != null && vdocos6.getNomtec() != null) {
			where.append(" AND UPPER(t1.NOMTEC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getNomtec().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getNomtec().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMTEC IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getCodtec() != null) {
			where.append(" AND UPPER(t1.CODTEC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getCodtec().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getCodtec().toUpperCase() + "%");
			}
			where.append(" AND t1.CODTEC IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getFechavis() != null) {
			where.append(" AND t1.FECHAVIS = ?");
			params.add(vdocos6.getFechavis());
		}
		if (vdocos6 != null && vdocos6.getFecharevi() != null) {
			where.append(" AND t1.FECHAREVI = ?");
			params.add(vdocos6.getFecharevi());
		}
		if (vdocos6 != null && vdocos6.getNomempresa() != null) {
			where.append(" AND UPPER(t1.NOMEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getNomempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getNomempresa().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMEMPRESA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getNifempresa() != null) {
			where.append(" AND UPPER(t1.NIFEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getNifempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getNifempresa().toUpperCase() + "%");
			}
			where.append(" AND t1.NIFEMPRESA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getProvssemp() != null) {
			where.append(" AND UPPER(t1.PROVSSEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getProvssemp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getProvssemp().toUpperCase() + "%");
			}
			where.append(" AND t1.PROVSSEMP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getNumssemp() != null) {
			where.append(" AND UPPER(t1.NUMSSEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getNumssemp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getNumssemp().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMSSEMP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getDigssemp() != null) {
			where.append(" AND UPPER(t1.DIGSSEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getDigssemp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getDigssemp().toUpperCase() + "%");
			}
			where.append(" AND t1.DIGSSEMP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getDomicilioemp() != null) {
			where.append(" AND UPPER(t1.DOMICILIOEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getDomicilioemp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getDomicilioemp().toUpperCase() + "%");
			}
			where.append(" AND t1.DOMICILIOEMP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getCodpostalemp() != null) {
			where.append(" AND UPPER(t1.CODPOSTALEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getCodpostalemp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getCodpostalemp().toUpperCase() + "%");
			}
			where.append(" AND t1.CODPOSTALEMP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getCnaeemp() != null) {
			where.append(" AND UPPER(t1.CNAEEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getCnaeemp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getCnaeemp().toUpperCase() + "%");
			}
			where.append(" AND t1.CNAEEMP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getTipapersi() != null) {
			where.append(" AND UPPER(t1.TIPAPERSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getTipapersi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getTipapersi().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPAPERSI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getTipaperno() != null) {
			where.append(" AND UPPER(t1.TIPAPERNO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getTipaperno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getTipaperno().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPAPERNO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getNumtra() != null) {
			where.append(" AND t1.NUMTRA = ?");
			params.add(vdocos6.getNumtra());
		}
		if (vdocos6 != null && vdocos6.getDomiciliocen() != null) {
			where.append(" AND UPPER(t1.DOMICILIOCEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getDomiciliocen().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getDomiciliocen().toUpperCase() + "%");
			}
			where.append(" AND t1.DOMICILIOCEN IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getCodpostalcen() != null) {
			where.append(" AND UPPER(t1.CODPOSTALCEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getCodpostalcen().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getCodpostalcen().toUpperCase() + "%");
			}
			where.append(" AND t1.CODPOSTALCEN IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getTelcen() != null) {
			where.append(" AND UPPER(t1.TELCEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getTelcen().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getTelcen().toUpperCase() + "%");
			}
			where.append(" AND t1.TELCEN IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getFaxcen() != null) {
			where.append(" AND UPPER(t1.FAXCEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getFaxcen().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getFaxcen().toUpperCase() + "%");
			}
			where.append(" AND t1.FAXCEN IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getEmailcen() != null) {
			where.append(" AND UPPER(t1.EMAILCEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getEmailcen().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getEmailcen().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAILCEN IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getCodmod() != null) {
			where.append(" AND UPPER(t1.CODMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getCodmod().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getCodmod().toUpperCase() + "%");
			}
			where.append(" AND t1.CODMOD IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMopemp() != null) {
			where.append(" AND UPPER(t1.MOPEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMopemp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMopemp().toUpperCase() + "%");
			}
			where.append(" AND t1.MOPEMP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getForempsi() != null) {
			where.append(" AND UPPER(t1.FOREMPSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getForempsi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getForempsi().toUpperCase() + "%");
			}
			where.append(" AND t1.FOREMPSI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getForempsib() != null) {
			where.append(" AND UPPER(t1.FOREMPSIB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getForempsib().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getForempsib().toUpperCase() + "%");
			}
			where.append(" AND t1.FOREMPSIB IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getForempsii() != null) {
			where.append(" AND UPPER(t1.FOREMPSII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getForempsii().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getForempsii().toUpperCase() + "%");
			}
			where.append(" AND t1.FOREMPSII IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getForempsis() != null) {
			where.append(" AND UPPER(t1.FOREMPSIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getForempsis().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getForempsis().toUpperCase() + "%");
			}
			where.append(" AND t1.FOREMPSIS IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getForempno() != null) {
			where.append(" AND UPPER(t1.FOREMPNO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getForempno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getForempno().toUpperCase() + "%");
			}
			where.append(" AND t1.FOREMPNO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMoptra() != null) {
			where.append(" AND UPPER(t1.MOPTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMoptra().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMoptra().toUpperCase() + "%");
			}
			where.append(" AND t1.MOPTRA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getNumtramop() != null) {
			where.append(" AND t1.NUMTRAMOP = ?");
			params.add(vdocos6.getNumtramop());
		}
		if (vdocos6 != null && vdocos6.getFortrasi() != null) {
			where.append(" AND UPPER(t1.FORTRASI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getFortrasi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getFortrasi().toUpperCase() + "%");
			}
			where.append(" AND t1.FORTRASI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getNumtrasi() != null) {
			where.append(" AND t1.NUMTRASI = ?");
			params.add(vdocos6.getNumtrasi());
		}
		if (vdocos6 != null && vdocos6.getFortrasib() != null) {
			where.append(" AND UPPER(t1.FORTRASIB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getFortrasib().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getFortrasib().toUpperCase() + "%");
			}
			where.append(" AND t1.FORTRASIB IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getFortrasii() != null) {
			where.append(" AND UPPER(t1.FORTRASII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getFortrasii().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getFortrasii().toUpperCase() + "%");
			}
			where.append(" AND t1.FORTRASII IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getFortrasis() != null) {
			where.append(" AND UPPER(t1.FORTRASIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getFortrasis().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getFortrasis().toUpperCase() + "%");
			}
			where.append(" AND t1.FORTRASIS IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getFortrano() != null) {
			where.append(" AND UPPER(t1.FORTRANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getFortrano().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getFortrano().toUpperCase() + "%");
			}
			where.append(" AND t1.FORTRANO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getNumtrano() != null) {
			where.append(" AND t1.NUMTRANO = ?");
			params.add(vdocos6.getNumtrano());
		}
		if (vdocos6 != null && vdocos6.getMopspp() != null) {
			where.append(" AND UPPER(t1.MOPSPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMopspp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMopspp().toUpperCase() + "%");
			}
			where.append(" AND t1.MOPSPP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getSegspp() != null) {
			where.append(" AND UPPER(t1.SEGSPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getSegspp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getSegspp().toUpperCase() + "%");
			}
			where.append(" AND t1.SEGSPP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getHigspp() != null) {
			where.append(" AND UPPER(t1.HIGSPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getHigspp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getHigspp().toUpperCase() + "%");
			}
			where.append(" AND t1.HIGSPP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getErgspp() != null) {
			where.append(" AND UPPER(t1.ERGSPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getErgspp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getErgspp().toUpperCase() + "%");
			}
			where.append(" AND t1.ERGSPP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedspp() != null) {
			where.append(" AND UPPER(t1.MEDSPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedspp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedspp().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDSPP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMopspa() != null) {
			where.append(" AND UPPER(t1.MOPSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMopspa().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMopspa().toUpperCase() + "%");
			}
			where.append(" AND t1.MOPSPA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getSegspa() != null) {
			where.append(" AND UPPER(t1.SEGSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getSegspa().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getSegspa().toUpperCase() + "%");
			}
			where.append(" AND t1.SEGSPA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getHigspa() != null) {
			where.append(" AND UPPER(t1.HIGSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getHigspa().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getHigspa().toUpperCase() + "%");
			}
			where.append(" AND t1.HIGSPA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getErgspa() != null) {
			where.append(" AND UPPER(t1.ERGSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getErgspa().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getErgspa().toUpperCase() + "%");
			}
			where.append(" AND t1.ERGSPA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedspa() != null) {
			where.append(" AND UPPER(t1.MEDSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedspa().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedspa().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDSPA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getNomspa() != null) {
			where.append(" AND UPPER(t1.NOMSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getNomspa().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getNomspa().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMSPA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getComseg() != null) {
			where.append(" AND UPPER(t1.COMSEG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getComseg().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getComseg().toUpperCase() + "%");
			}
			where.append(" AND t1.COMSEG IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getNumcomseg1() != null) {
			where.append(" AND t1.NUMCOMSEG1 = ?");
			params.add(vdocos6.getNumcomseg1());
		}
		if (vdocos6 != null && vdocos6.getNumcomseg2() != null) {
			where.append(" AND t1.NUMCOMSEG2 = ?");
			params.add(vdocos6.getNumcomseg2());
		}
		if (vdocos6 != null && vdocos6.getDelpre() != null) {
			where.append(" AND UPPER(t1.DELPRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getDelpre().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getDelpre().toUpperCase() + "%");
			}
			where.append(" AND t1.DELPRE IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getNumdel() != null) {
			where.append(" AND t1.NUMDEL = ?");
			params.add(vdocos6.getNumdel());
		}
		if (vdocos6 != null && vdocos6.getForpresi() != null) {
			where.append(" AND UPPER(t1.FORPRESI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getForpresi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getForpresi().toUpperCase() + "%");
			}
			where.append(" AND t1.FORPRESI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getNumdefsi() != null) {
			where.append(" AND t1.NUMDEFSI = ?");
			params.add(vdocos6.getNumdefsi());
		}
		if (vdocos6 != null && vdocos6.getForpreno() != null) {
			where.append(" AND UPPER(t1.FORPRENO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getForpreno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getForpreno().toUpperCase() + "%");
			}
			where.append(" AND t1.FORPRENO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getNumdefno() != null) {
			where.append(" AND t1.NUMDEFNO = ?");
			params.add(vdocos6.getNumdefno());
		}
		if (vdocos6 != null && vdocos6.getCodmer() != null) {
			where.append(" AND UPPER(t1.CODMER) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getCodmer().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getCodmer().toUpperCase() + "%");
			}
			where.append(" AND t1.CODMER IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getIndersi() != null) {
			where.append(" AND UPPER(t1.INDERSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getIndersi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getIndersi().toUpperCase() + "%");
			}
			where.append(" AND t1.INDERSI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getInderno() != null) {
			where.append(" AND UPPER(t1.INDERNO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getInderno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getInderno().toUpperCase() + "%");
			}
			where.append(" AND t1.INDERNO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getRieemp() != null) {
			where.append(" AND UPPER(t1.RIEEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getRieemp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getRieemp().toUpperCase() + "%");
			}
			where.append(" AND t1.RIEEMP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getRietra() != null) {
			where.append(" AND UPPER(t1.RIETRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getRietra().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getRietra().toUpperCase() + "%");
			}
			where.append(" AND t1.RIETRA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getRiespp() != null) {
			where.append(" AND UPPER(t1.RIESPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getRiespp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getRiespp().toUpperCase() + "%");
			}
			where.append(" AND t1.RIESPP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getRieotro() != null) {
			where.append(" AND UPPER(t1.RIEOTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getRieotro().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getRieotro().toUpperCase() + "%");
			}
			where.append(" AND t1.RIEOTRO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getRiespa() != null) {
			where.append(" AND UPPER(t1.RIESPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getRiespa().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getRiespa().toUpperCase() + "%");
			}
			where.append(" AND t1.RIESPA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getDesotro() != null) {
			where.append(" AND UPPER(t1.DESOTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getDesotro().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getDesotro().toUpperCase() + "%");
			}
			where.append(" AND t1.DESOTRO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getFirmsi() != null) {
			where.append(" AND UPPER(t1.FIRMSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getFirmsi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getFirmsi().toUpperCase() + "%");
			}
			where.append(" AND t1.FIRMSI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getFirmno() != null) {
			where.append(" AND UPPER(t1.FIRMNO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getFirmno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getFirmno().toUpperCase() + "%");
			}
			where.append(" AND t1.FIRMNO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getPardelesi() != null) {
			where.append(" AND UPPER(t1.PARDELESI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getPardelesi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getPardelesi().toUpperCase() + "%");
			}
			where.append(" AND t1.PARDELESI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getPardeleno() != null) {
			where.append(" AND UPPER(t1.PARDELENO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getPardeleno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getPardeleno().toUpperCase() + "%");
			}
			where.append(" AND t1.PARDELENO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getPartrasi() != null) {
			where.append(" AND UPPER(t1.PARTRASI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getPartrasi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getPartrasi().toUpperCase() + "%");
			}
			where.append(" AND t1.PARTRASI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getPartrano() != null) {
			where.append(" AND UPPER(t1.PARTRANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getPartrano().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getPartrano().toUpperCase() + "%");
			}
			where.append(" AND t1.PARTRANO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getCondelesi() != null) {
			where.append(" AND UPPER(t1.CONDELESI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getCondelesi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getCondelesi().toUpperCase() + "%");
			}
			where.append(" AND t1.CONDELESI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getCondeleno() != null) {
			where.append(" AND UPPER(t1.CONDELENO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getCondeleno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getCondeleno().toUpperCase() + "%");
			}
			where.append(" AND t1.CONDELENO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getInftrasi() != null) {
			where.append(" AND UPPER(t1.INFTRASI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getInftrasi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getInftrasi().toUpperCase() + "%");
			}
			where.append(" AND t1.INFTRASI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getInftrano() != null) {
			where.append(" AND UPPER(t1.INFTRANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getInftrano().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getInftrano().toUpperCase() + "%");
			}
			where.append(" AND t1.INFTRANO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedplasi() != null) {
			where.append(" AND UPPER(t1.MEDPLASI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedplasi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedplasi().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDPLASI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedplano() != null) {
			where.append(" AND UPPER(t1.MEDPLANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedplano().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedplano().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDPLANO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedressi() != null) {
			where.append(" AND UPPER(t1.MEDRESSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedressi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedressi().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDRESSI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedresno() != null) {
			where.append(" AND UPPER(t1.MEDRESNO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedresno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedresno().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDRESNO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedfecsi() != null) {
			where.append(" AND UPPER(t1.MEDFECSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedfecsi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedfecsi().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDFECSI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedfecno() != null) {
			where.append(" AND UPPER(t1.MEDFECNO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedfecno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedfecno().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDFECNO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedpresi() != null) {
			where.append(" AND UPPER(t1.MEDPRESI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedpresi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedpresi().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDPRESI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedpreno() != null) {
			where.append(" AND UPPER(t1.MEDPRENO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedpreno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedpreno().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDPRENO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getCodmed() != null) {
			where.append(" AND UPPER(t1.CODMED) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getCodmed().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getCodmed().toUpperCase() + "%");
			}
			where.append(" AND t1.CODMED IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedplaactsi() != null) {
			where.append(" AND UPPER(t1.MEDPLAACTSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedplaactsi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedplaactsi().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDPLAACTSI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedplaactno() != null) {
			where.append(" AND UPPER(t1.MEDPLAACTNO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedplaactno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedplaactno().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDPLAACTNO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getConplatrasi() != null) {
			where.append(" AND UPPER(t1.CONPLATRASI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getConplatrasi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getConplatrasi().toUpperCase() + "%");
			}
			where.append(" AND t1.CONPLATRASI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getConplatrano() != null) {
			where.append(" AND UPPER(t1.CONPLATRANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getConplatrano().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getConplatrano().toUpperCase() + "%");
			}
			where.append(" AND t1.CONPLATRANO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedsimusi() != null) {
			where.append(" AND UPPER(t1.MEDSIMUSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedsimusi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedsimusi().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDSIMUSI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getMedsimuno() != null) {
			where.append(" AND UPPER(t1.MEDSIMUNO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getMedsimuno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getMedsimuno().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDSIMUNO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getRmeemp() != null) {
			where.append(" AND UPPER(t1.RMEEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getRmeemp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getRmeemp().toUpperCase() + "%");
			}
			where.append(" AND t1.RMEEMP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getRmetra() != null) {
			where.append(" AND UPPER(t1.RMETRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getRmetra().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getRmetra().toUpperCase() + "%");
			}
			where.append(" AND t1.RMETRA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getRmespp() != null) {
			where.append(" AND UPPER(t1.RMESPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getRmespp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getRmespp().toUpperCase() + "%");
			}
			where.append(" AND t1.RMESPP IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getRmeotro() != null) {
			where.append(" AND UPPER(t1.RMEOTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getRmeotro().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getRmeotro().toUpperCase() + "%");
			}
			where.append(" AND t1.RMEOTRO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getRmespa() != null) {
			where.append(" AND UPPER(t1.RMESPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getRmespa().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getRmespa().toUpperCase() + "%");
			}
			where.append(" AND t1.RMESPA IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getDesotro2() != null) {
			where.append(" AND UPPER(t1.DESOTRO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getDesotro2().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getDesotro2().toUpperCase() + "%");
			}
			where.append(" AND t1.DESOTRO2 IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getFortrapre() != null) {
			where.append(" AND UPPER(t1.FORTRAPRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getFortrapre().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getFortrapre().toUpperCase() + "%");
			}
			where.append(" AND t1.FORTRAPRE IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getVigsal() != null) {
			where.append(" AND UPPER(t1.VIGSAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getVigsal().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getVigsal().toUpperCase() + "%");
			}
			where.append(" AND t1.VIGSAL IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getTrasen() != null) {
			where.append(" AND UPPER(t1.TRASEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getTrasen().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getTrasen().toUpperCase() + "%");
			}
			where.append(" AND t1.TRASEN IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getTramen() != null) {
			where.append(" AND UPPER(t1.TRAMEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getTramen().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getTramen().toUpperCase() + "%");
			}
			where.append(" AND t1.TRAMEN IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getTramat() != null) {
			where.append(" AND UPPER(t1.TRAMAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getTramat().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getTramat().toUpperCase() + "%");
			}
			where.append(" AND t1.TRAMAT IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getInfnuesi() != null) {
			where.append(" AND UPPER(t1.INFNUESI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getInfnuesi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getInfnuesi().toUpperCase() + "%");
			}
			where.append(" AND t1.INFNUESI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getInfnueno() != null) {
			where.append(" AND UPPER(t1.INFNUENO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getInfnueno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getInfnueno().toUpperCase() + "%");
			}
			where.append(" AND t1.INFNUENO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getPlanacogsi() != null) {
			where.append(" AND UPPER(t1.PLANACOGSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getPlanacogsi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getPlanacogsi().toUpperCase() + "%");
			}
			where.append(" AND t1.PLANACOGSI IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getPlanacogno() != null) {
			where.append(" AND UPPER(t1.PLANACOGNO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getPlanacogno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getPlanacogno().toUpperCase() + "%");
			}
			where.append(" AND t1.PLANACOGNO IS NOT NULL");
		}
		if (vdocos6 != null && vdocos6.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos6.getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos6.getObservaciones().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
